/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.model.Operation;

public enum ClusterState {
    ACTIVATED(Operation.GET, Operation.SET, Operation.UNSET),
    CONFIGURING(Operation.GET, Operation.SET, Operation.UNSET, Operation.IMPORT);

    private final Collection<Operation> supportedOperations;

    private ClusterState(Operation ... operations) {
        this.supportedOperations = Arrays.asList(operations);
    }

    public Collection<Operation> getOperations() {
        return Collections.unmodifiableCollection(this.supportedOperations);
    }

    public Stream<Operation> filter(Operation ... superset) {
        return Stream.of(superset).filter(this.supportedOperations::contains);
    }

    public boolean supports(Operation operation) {
        return this.supportedOperations.contains((Object)operation);
    }

    public String toString() {
        return "node is " + this.name().toLowerCase();
    }
}

