/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.Stage;
import com.tc.util.State;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageController {
    private static Logger LOGGER = LoggerFactory.getLogger(StageController.class);
    private final Map<State, Set<String>> states = new HashMap<State, Set<String>>();
    private final Map<String, Consumer<State>> triggers = new HashMap<String, Consumer<State>>();
    private final Supplier<ConfigurationContext> context;

    public StageController(Supplier<ConfigurationContext> getter) {
        this.context = getter;
    }

    public synchronized void addStageToState(State state, String stage) {
        Set<String> list = this.states.get(state);
        if (list == null) {
            list = new LinkedHashSet<String>();
            this.states.put(state, list);
        }
        list.add(stage);
    }

    public synchronized void addTriggerToState(State state, Consumer<State> trigger) {
        Set<String> list = this.states.get(state);
        String uuid = "TRIGGER-" + UUID.randomUUID().toString();
        this.triggers.put(uuid, trigger);
        if (list == null) {
            list = new LinkedHashSet<String>();
            this.states.put(state, list);
        }
        list.add(uuid);
    }

    public void transition(State old, State current) {
        Stage<Object> st;
        ConfigurationContext cxt = this.context.get();
        Set<String> leaving = this.states.get(old);
        Set<String> coming = this.states.get(current);
        if (leaving == null) {
            leaving = Collections.emptySet();
        }
        if (coming == null) {
            coming = Collections.emptySet();
        }
        for (String s : leaving) {
            try {
                st = cxt.getStage(s, Object.class);
                if (st == null || coming.contains(s)) continue;
                st.destroy();
            }
            catch (Exception e) {
                LOGGER.error("failed to destroy stage {}", (Object)s);
                throw new RuntimeException(e);
            }
        }
        for (String s : coming) {
            if (s.startsWith("TRIGGER-")) {
                this.triggers.get(s).accept(old);
                continue;
            }
            try {
                st = cxt.getStage(s, Object.class);
                if (st == null || leaving.contains(s) || st.isStarted()) continue;
                st.start(cxt);
                st.unpause();
            }
            catch (Exception e) {
                LOGGER.error("failed to start stage {}", (Object)s);
                throw new RuntimeException(e);
            }
        }
    }
}

