/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.net.protocol.transport.ClientConnectionErrorDetails;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientEntityManager;
import com.tc.object.DistributedObjectClient;
import com.tc.object.DistributedObjectClientFactory;
import com.tc.object.StandardClientBuilderFactory;
import com.tc.util.concurrent.SetOnceFlag;
import com.terracotta.connection.ClientHandle;
import com.terracotta.connection.ClientHandleImpl;
import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.api.DetailedConnectionException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.terracotta.exception.ConnectionClosedException;

public class TerracottaInternalClientImpl
implements TerracottaInternalClient {
    private final DistributedObjectClientFactory clientCreator;
    private final ClientConnectionErrorDetails errorListener = new ClientConnectionErrorDetails();
    private volatile ClientHandle clientHandle;
    private SetOnceFlag isInitialized = new SetOnceFlag();

    TerracottaInternalClientImpl(String scheme, Iterable<InetSocketAddress> serverAddresses, Properties props) {
        try {
            this.clientCreator = this.buildClientCreator(scheme, serverAddresses, props);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DistributedObjectClientFactory buildClientCreator(String scheme, Iterable<InetSocketAddress> serverAddresses, Properties props) {
        ClientBuilder clientBuilder = new StandardClientBuilderFactory(scheme).create(props);
        if (clientBuilder == null) {
            throw new RuntimeException("unable to build the client");
        }
        clientBuilder.setClientConnectionErrorListener(this.errorListener);
        return new DistributedObjectClientFactory(serverAddresses, clientBuilder, props);
    }

    @Override
    public void init() throws DetailedConnectionException {
        block8: {
            if (!this.isInitialized.attemptSet()) {
                return;
            }
            DistributedObjectClient client = null;
            this.errorListener.attachCollector();
            try {
                try {
                    client = this.clientCreator.create(this::destroy);
                }
                catch (ConfigurationSetupException | InterruptedException | TimeoutException to) {
                    throw new DetailedConnectionException(to, this.errorListener.getErrors());
                }
                catch (RuntimeException e) {
                    throw new DetailedConnectionException(new Exception(DetailedConnectionException.getDetailedMessage(this.errorListener.getErrors()), e), this.errorListener.getErrors());
                }
                if (client != null) {
                    this.clientHandle = new ClientHandleImpl(client);
                    break block8;
                }
                throw new DetailedConnectionException(new IOException("Connection refused"), this.errorListener.getErrors());
            }
            finally {
                this.errorListener.removeCollector();
            }
        }
    }

    @Override
    public boolean isShutdown() {
        try {
            return this.getHandle().isShutdown();
        }
        catch (ConnectionClosedException closed) {
            return true;
        }
    }

    @Override
    public void shutdown() {
        try {
            this.getHandle().shutdown();
        }
        catch (ConnectionClosedException connectionClosedException) {
            // empty catch block
        }
    }

    private void destroy() {
        this.clientHandle = null;
    }

    private ClientHandle getHandle() {
        ClientHandle handle = this.clientHandle;
        if (handle == null) {
            throw new ConnectionClosedException("connection delared dead");
        }
        return handle;
    }

    @Override
    public ClientEntityManager getClientEntityManager() {
        try {
            return this.clientHandle.getClientEntityManager();
        }
        catch (NullPointerException n) {
            throw new ConnectionClosedException("connection delared dead");
        }
    }

    static class ClientShutdownException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ClientShutdownException() {
        }
    }
}

