/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.ehcache.clustered.common.internal.messages.CodecUtil;

public class ReconnectDataCodec {
    private static final byte ENTRY_SIZE = 4;

    public byte[] encode(Set<String> cacheIds, int length) {
        ByteBuffer reconnectData = ByteBuffer.allocate(2 * length + cacheIds.size() * 4);
        for (String cacheId : cacheIds) {
            reconnectData.putInt(cacheId.length());
            CodecUtil.putStringAsCharArray(reconnectData, cacheId);
        }
        return reconnectData.array();
    }

    public Set<String> decode(byte[] payload) {
        HashSet<String> cacheIds = new HashSet<String>();
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        while (byteBuffer.hasRemaining()) {
            int cacheIdSize = byteBuffer.getInt();
            cacheIds.add(CodecUtil.getStringFromBuffer(byteBuffer, cacheIdSize));
        }
        return cacheIds;
    }
}

