/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ehcache.clustered.client.internal.EhcacheClientEntity;
import org.ehcache.clustered.client.internal.store.NoInvalidationServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.ServerStoreMessageFactory;
import org.ehcache.clustered.common.internal.store.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrongServerStoreProxy
implements ServerStoreProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrongServerStoreProxy.class);
    private final ServerStoreProxy delegate;
    private final ConcurrentMap<Long, CountDownLatch> hashInvalidationsInProgress = new ConcurrentHashMap<Long, CountDownLatch>();
    private final Lock invalidateAllLock = new ReentrantLock();
    private CountDownLatch invalidateAllLatch;
    private final List<ServerStoreProxy.InvalidationListener> invalidationListeners = new CopyOnWriteArrayList<ServerStoreProxy.InvalidationListener>();
    private final EhcacheClientEntity entity;

    public StrongServerStoreProxy(final ServerStoreMessageFactory messageFactory, final EhcacheClientEntity entity) {
        this.delegate = new NoInvalidationServerStoreProxy(messageFactory, entity);
        this.entity = entity;
        entity.addResponseListener(EhcacheEntityResponse.HashInvalidationDone.class, new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.HashInvalidationDone>(){

            @Override
            public void onResponse(EhcacheEntityResponse.HashInvalidationDone response) {
                if (response.getCacheId().equals(messageFactory.getCacheId())) {
                    long key = response.getKey();
                    LOGGER.debug("CLIENT: on cache {}, server notified that clients invalidated hash {}", (Object)messageFactory.getCacheId(), (Object)key);
                    CountDownLatch countDownLatch = (CountDownLatch)StrongServerStoreProxy.this.hashInvalidationsInProgress.remove(key);
                    if (countDownLatch != null) {
                        countDownLatch.countDown();
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
        entity.addResponseListener(EhcacheEntityResponse.AllInvalidationDone.class, new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.AllInvalidationDone>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(EhcacheEntityResponse.AllInvalidationDone response) {
                if (response.getCacheId().equals(messageFactory.getCacheId())) {
                    CountDownLatch countDownLatch;
                    LOGGER.debug("CLIENT: on cache {}, server notified that clients invalidated all", (Object)messageFactory.getCacheId());
                    StrongServerStoreProxy.this.invalidateAllLock.lock();
                    try {
                        countDownLatch = StrongServerStoreProxy.this.invalidateAllLatch;
                        StrongServerStoreProxy.this.invalidateAllLatch = null;
                    }
                    finally {
                        StrongServerStoreProxy.this.invalidateAllLock.unlock();
                    }
                    if (countDownLatch != null) {
                        LOGGER.debug("CLIENT: on cache {}, count down", (Object)messageFactory.getCacheId());
                        countDownLatch.countDown();
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
        entity.addResponseListener(EhcacheEntityResponse.ServerInvalidateHash.class, new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.ServerInvalidateHash>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ServerInvalidateHash response) {
                if (response.getCacheId().equals(messageFactory.getCacheId())) {
                    long key = response.getKey();
                    LOGGER.debug("CLIENT: on cache {}, server requesting hash {} to be invalidated", (Object)messageFactory.getCacheId(), (Object)key);
                    for (ServerStoreProxy.InvalidationListener listener : StrongServerStoreProxy.this.invalidationListeners) {
                        listener.onInvalidateHash(key);
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
        entity.addResponseListener(EhcacheEntityResponse.ClientInvalidateHash.class, new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.ClientInvalidateHash>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ClientInvalidateHash response) {
                String cacheId = response.getCacheId();
                long key = response.getKey();
                int invalidationId = response.getInvalidationId();
                if (cacheId.equals(messageFactory.getCacheId())) {
                    LOGGER.debug("CLIENT: doing work to invalidate hash {} from cache {} (ID {})", new Object[]{key, cacheId, invalidationId});
                    for (ServerStoreProxy.InvalidationListener listener : StrongServerStoreProxy.this.invalidationListeners) {
                        listener.onInvalidateHash(key);
                    }
                    try {
                        LOGGER.debug("CLIENT: ack'ing invalidation of hash {} from cache {} (ID {})", new Object[]{key, cacheId, invalidationId});
                        entity.invokeAsync(messageFactory.clientInvalidationAck(invalidationId), true);
                    }
                    catch (Exception e) {
                        LOGGER.error("error acking client invalidation of hash {} on cache {}", new Object[]{key, cacheId, e});
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
        entity.addResponseListener(EhcacheEntityResponse.ClientInvalidateAll.class, new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.ClientInvalidateAll>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ClientInvalidateAll response) {
                String cacheId = response.getCacheId();
                int invalidationId = response.getInvalidationId();
                if (cacheId.equals(messageFactory.getCacheId())) {
                    LOGGER.debug("CLIENT: doing work to invalidate all from cache {} (ID {})", (Object)cacheId, (Object)invalidationId);
                    for (ServerStoreProxy.InvalidationListener listener : StrongServerStoreProxy.this.invalidationListeners) {
                        listener.onInvalidateAll();
                    }
                    try {
                        LOGGER.debug("CLIENT: ack'ing invalidation of all from cache {} (ID {})", (Object)cacheId, (Object)invalidationId);
                        entity.invokeAsync(messageFactory.clientInvalidationAck(invalidationId), true);
                    }
                    catch (Exception e) {
                        LOGGER.error("error acking client invalidation of all on cache {}", (Object)cacheId, (Object)e);
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
        entity.addDisconnectionListener(new EhcacheClientEntity.DisconnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisconnection() {
                for (Map.Entry entry : StrongServerStoreProxy.this.hashInvalidationsInProgress.entrySet()) {
                    ((CountDownLatch)entry.getValue()).countDown();
                }
                StrongServerStoreProxy.this.hashInvalidationsInProgress.clear();
                StrongServerStoreProxy.this.invalidateAllLock.lock();
                try {
                    if (StrongServerStoreProxy.this.invalidateAllLatch != null) {
                        StrongServerStoreProxy.this.invalidateAllLatch.countDown();
                    }
                }
                finally {
                    StrongServerStoreProxy.this.invalidateAllLock.unlock();
                }
            }
        });
    }

    private <T> T performWaitingForHashInvalidation(long key, NullaryFunction<T> c) throws InterruptedException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(1);
        while (true) {
            if (!this.entity.isConnected()) {
                throw new IllegalStateException("Clustered tier manager disconnected");
            }
            CountDownLatch countDownLatch = this.hashInvalidationsInProgress.putIfAbsent(key, latch);
            if (countDownLatch == null) break;
            this.awaitOnLatch(countDownLatch);
        }
        try {
            T result = c.apply();
            this.awaitOnLatch(latch);
            LOGGER.debug("CLIENT: key {} invalidated on all clients, unblocking call", (Object)key);
            return result;
        }
        catch (Exception ex) {
            this.hashInvalidationsInProgress.remove(key);
            latch.countDown();
            if (ex instanceof TimeoutException) {
                throw (TimeoutException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T performWaitingForAllInvalidation(NullaryFunction<T> c) throws InterruptedException, TimeoutException {
        CountDownLatch newLatch = new CountDownLatch(1);
        while (true) {
            CountDownLatch existingLatch;
            if (!this.entity.isConnected()) {
                throw new IllegalStateException("Clustered tier manager disconnected");
            }
            this.invalidateAllLock.lock();
            try {
                existingLatch = this.invalidateAllLatch;
                if (existingLatch == null) {
                    this.invalidateAllLatch = newLatch;
                    break;
                }
            }
            finally {
                this.invalidateAllLock.unlock();
            }
            this.awaitOnLatch(existingLatch);
        }
        try {
            T result = c.apply();
            this.awaitOnLatch(newLatch);
            LOGGER.debug("CLIENT: all invalidated on all clients, unblocking call");
            return result;
        }
        catch (Exception ex) {
            this.invalidateAllLock.lock();
            try {
                this.invalidateAllLatch = null;
            }
            finally {
                this.invalidateAllLock.unlock();
            }
            newLatch.countDown();
            if (ex instanceof TimeoutException) {
                throw (TimeoutException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    private void awaitOnLatch(CountDownLatch countDownLatch) throws InterruptedException {
        int totalAwaitTime = 0;
        int backoff = 1;
        while (!countDownLatch.await(backoff, TimeUnit.SECONDS)) {
            backoff = backoff >= 10 ? 10 : backoff * 2;
            LOGGER.debug("Waiting for the server's InvalidationDone message for {}s, backing off {}s...", (Object)(totalAwaitTime += backoff), (Object)backoff);
        }
        if (!this.entity.isConnected()) {
            throw new IllegalStateException("Clustered tier manager disconnected");
        }
    }

    @Override
    public String getCacheId() {
        return this.delegate.getCacheId();
    }

    @Override
    public void addInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        this.invalidationListeners.add(listener);
    }

    @Override
    public boolean removeInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        return this.invalidationListeners.remove(listener);
    }

    @Override
    public Chain get(long key) throws TimeoutException {
        return this.delegate.get(key);
    }

    @Override
    public void append(final long key, final ByteBuffer payLoad) throws TimeoutException {
        try {
            this.performWaitingForHashInvalidation(key, new NullaryFunction<Void>(){

                @Override
                public Void apply() throws TimeoutException {
                    StrongServerStoreProxy.this.delegate.append(key, payLoad);
                    return null;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public Chain getAndAppend(final long key, final ByteBuffer payLoad) throws TimeoutException {
        try {
            return this.performWaitingForHashInvalidation(key, new NullaryFunction<Chain>(){

                @Override
                public Chain apply() throws TimeoutException {
                    return StrongServerStoreProxy.this.delegate.getAndAppend(key, payLoad);
                }
            });
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        this.delegate.replaceAtHead(key, expect, update);
    }

    @Override
    public void clear() throws TimeoutException {
        try {
            this.performWaitingForAllInvalidation(new NullaryFunction<Object>(){

                @Override
                public Object apply() throws TimeoutException {
                    StrongServerStoreProxy.this.delegate.clear();
                    return null;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private static interface NullaryFunction<T> {
        public T apply() throws Exception;
    }
}

