/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.ehcache.clustered.common.internal.store.Util;

public class StateRepositoryOpCodec {
    private static final byte OPCODE_SIZE = 1;

    public byte[] encode(StateRepositoryOpMessage message) {
        byte[] encodedMsg = Util.marshall(message);
        ByteBuffer buffer = ByteBuffer.allocate(1 + encodedMsg.length);
        buffer.put(message.getOpCode());
        buffer.put(encodedMsg);
        return buffer.array();
    }

    public StateRepositoryOpMessage decode(byte[] payload) {
        ByteBuffer message = ByteBuffer.wrap(payload);
        byte[] encodedMsg = new byte[message.capacity() - 1];
        byte opCode = message.get();
        if (opCode == EhcacheEntityMessage.Type.STATE_REPO_OP.getCode()) {
            message.get(encodedMsg, 0, encodedMsg.length);
            StateRepositoryOpMessage entityMessage = (StateRepositoryOpMessage)Util.unmarshall(encodedMsg);
            return entityMessage;
        }
        throw new UnsupportedOperationException("State repository operation not defined for : " + opCode);
    }
}

