/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.EhcacheClientEntity;
import org.ehcache.clustered.client.internal.service.ClusteredMapException;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.StateRepositoryMessageFactory;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;

public class ConcurrentClusteredMap<K, V>
implements ConcurrentMap<K, V> {
    private final StateRepositoryMessageFactory messageFactory;
    private final EhcacheClientEntity entity;

    public ConcurrentClusteredMap(String cacheId, String mapId, EhcacheClientEntity entity) {
        this.messageFactory = new StateRepositoryMessageFactory(cacheId, mapId);
        this.entity = entity;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public V get(Object key) {
        return (V)this.getResponse(this.messageFactory.getMessage(key));
    }

    private Object getResponse(StateRepositoryOpMessage message) {
        try {
            EhcacheEntityResponse response = this.entity.invoke(message, true);
            return ((EhcacheEntityResponse.MapValue)response).getValue();
        }
        catch (ClusterException ce) {
            throw new ClusteredMapException(ce);
        }
        catch (TimeoutException te) {
            throw new ClusteredMapException(te);
        }
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return (Set)this.getResponse(this.messageFactory.entrySetMessage());
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)this.getResponse(this.messageFactory.putIfAbsentMessage(key, value));
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException("TODO");
    }
}

