/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.net.ClientID;
import com.tc.object.locks.ClientLockImpl;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockLevel;
import com.tc.object.locks.ServerLockContext;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.util.Assert;
import com.tc.util.FindbugsSuppressWarnings;
import com.tc.util.SinglyLinkedList;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

abstract class LockStateNode
implements SinglyLinkedList.LinkedNode<LockStateNode> {
    private static final ExecutorService UNPARK_HANDLER = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Unpark Handler Thread");
            t.setDaemon(true);
            return t;
        }
    });
    private final ThreadID owner;
    private LockStateNode next;

    LockStateNode(ThreadID owner) {
        this.owner = owner;
        this.next = null;
    }

    void park() throws InterruptedException {
        throw new AssertionError();
    }

    void park(long timeout) throws InterruptedException {
        throw new AssertionError();
    }

    void unpark() {
        throw new AssertionError();
    }

    ThreadID getOwner() {
        return this.owner;
    }

    ClientLockImpl.LockAcquireResult allowsHold(LockHold newHold) {
        return ClientLockImpl.LockAcquireResult.UNKNOWN;
    }

    abstract ClientServerExchangeLockContext toContext(LockID var1, ClientID var2);

    @Override
    public LockStateNode getNext() {
        return this.next;
    }

    @Override
    public LockStateNode setNext(LockStateNode newNext) {
        LockStateNode old = this.next;
        this.next = newNext;
        return old;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LockStateNode) {
            return this.owner.equals(((LockStateNode)o).owner);
        }
        return false;
    }

    public int hashCode() {
        return this.owner.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : " + this.owner;
    }

    public static void shutdown() {
        UNPARK_HANDLER.shutdown();
    }

    static class LockWaiter
    extends LockStateNode {
        private final Object waitObject;
        private final long waitTime;
        private final Stack<PendingLockHold> reacquires;
        private boolean notified = false;

        LockWaiter(ThreadID owner, Object waitObject, Stack<LockHold> holds, long timeout) {
            super(owner);
            this.waitObject = waitObject == null ? this : waitObject;
            this.reacquires = new Stack();
            for (LockHold hold : holds) {
                this.reacquires.add(new MonitorBasedPendingLockHold(owner, hold.getLockLevel(), this.waitObject));
            }
            this.waitTime = timeout;
        }

        long getTimeout() {
            return this.waitTime;
        }

        Stack<PendingLockHold> getReacquires() {
            return this.reacquires;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @FindbugsSuppressWarnings(value={"WA_NOT_IN_LOOP"})
        void park() throws InterruptedException {
            Object object = this.waitObject;
            synchronized (object) {
                if (!this.notified) {
                    this.waitObject.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void park(long timeout) throws InterruptedException {
            Object object = this.waitObject;
            synchronized (object) {
                if (!this.notified) {
                    this.waitObject.wait(timeout);
                }
            }
        }

        @Override
        void unpark() {
            Runnable unparker = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = LockWaiter.this.waitObject;
                    synchronized (object) {
                        LockWaiter.this.notified = true;
                        LockWaiter.this.waitObject.notifyAll();
                    }
                }
            };
            try {
                UNPARK_HANDLER.execute(unparker);
            }
            catch (RejectedExecutionException e) {
                new Thread(unparker, "Temporary Unpark Thread [" + this.toString() + "]").start();
            }
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof LockWaiter) {
                return super.equals(o);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID node) {
            return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.WAITER, this.getTimeout());
        }
    }

    static class MonitorBasedPendingLockHold
    extends PendingLockHold {
        private final Object waitObject;
        private boolean unparked = false;

        MonitorBasedPendingLockHold(ThreadID owner, LockLevel level, Object waitObject) {
            super(owner, level);
            this.waitObject = waitObject == null ? this : waitObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void park() {
            Object object = this.waitObject;
            synchronized (object) {
                while (!this.unparked) {
                    try {
                        this.waitObject.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.unparked = true;
                    }
                }
                this.unparked = false;
            }
        }

        @Override
        void unpark() {
            Runnable unparker = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = MonitorBasedPendingLockHold.this.waitObject;
                    synchronized (object) {
                        MonitorBasedPendingLockHold.this.unparked = true;
                        MonitorBasedPendingLockHold.this.waitObject.notifyAll();
                    }
                }
            };
            try {
                UNPARK_HANDLER.execute(unparker);
            }
            catch (RejectedExecutionException e) {
                new Thread(unparker, "Temporary Unparker Thread [" + this.toString() + "]").start();
            }
        }

        @Override
        boolean canDelegate() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof MonitorBasedPendingLockHold) {
                return super.equals(o);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    static class PendingTryLockHold
    extends PendingLockHold {
        private final long waitTime;

        PendingTryLockHold(ThreadID owner, LockLevel level, long timeout) {
            super(owner, level);
            this.waitTime = timeout;
        }

        long getTimeout() {
            return this.waitTime;
        }

        @Override
        boolean isRefused() {
            return this.responded && !this.awarded;
        }

        @Override
        void refused() {
            this.awarded = false;
            this.responded = true;
        }

        @Override
        @FindbugsSuppressWarnings(value={"RV_RETURN_VALUE_IGNORED"})
        void park(long timeout) {
            Assert.assertEquals(this.getJavaThread(), Thread.currentThread());
            try {
                this.permit.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID node) {
            ServerLockLevel serverLevel = ServerLockLevel.fromClientLockLevel(this.getLockLevel());
            if (this.isAwarded()) {
                switch (serverLevel) {
                    case READ: {
                        return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.HOLDER_READ);
                    }
                    case WRITE: {
                        return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.HOLDER_WRITE);
                    }
                }
                throw new AssertionError((Object)serverLevel);
            }
            switch (serverLevel) {
                case READ: {
                    return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.TRY_PENDING_READ, this.getTimeout());
                }
                case WRITE: {
                    return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.TRY_PENDING_WRITE, this.getTimeout());
                }
            }
            throw new AssertionError((Object)serverLevel);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PendingTryLockHold) {
                return super.equals(o) && this.waitTime == ((PendingTryLockHold)o).waitTime;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 5 * super.hashCode() ^ 7 * (int)this.waitTime ^ 11 * (int)(this.waitTime >>> 32);
        }

        @Override
        public String toString() {
            return super.toString() + ", timeout=" + this.getTimeout();
        }
    }

    static class PendingLockHold
    extends LockStateNode {
        private final LockLevel level;
        private final Thread javaThread;
        final Semaphore permit = new Semaphore(0);
        private volatile boolean delegates = true;
        volatile boolean responded = false;
        volatile boolean awarded = false;
        private volatile String delegationMethod = "Not Delegated";

        PendingLockHold(ThreadID owner, LockLevel level) {
            super(owner);
            this.javaThread = Thread.currentThread();
            this.level = level;
        }

        LockLevel getLockLevel() {
            return this.level;
        }

        Thread getJavaThread() {
            return this.javaThread;
        }

        @Override
        void park() {
            Assert.assertEquals(this.getJavaThread(), Thread.currentThread());
            try {
                this.permit.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        void unpark() {
            this.permit.release();
        }

        boolean canDelegate() {
            return this.delegates;
        }

        void delegated(String method) {
            if (this.delegates) {
                this.delegationMethod = method;
            }
            this.delegates = false;
        }

        void refused() {
        }

        void awarded() {
            this.awarded = true;
            this.responded = true;
        }

        boolean isRefused() {
            return false;
        }

        boolean isAwarded() {
            return this.responded && this.awarded;
        }

        @Override
        ClientLockImpl.LockAcquireResult allowsHold(LockHold newHold) {
            if (this.getOwner().equals(newHold.getOwner()) && this.getLockLevel().equals((Object)newHold.getLockLevel())) {
                if (this.isAwarded()) {
                    return ClientLockImpl.LockAcquireResult.SUCCESS;
                }
                if (this.isRefused()) {
                    return ClientLockImpl.LockAcquireResult.FAILURE;
                }
            }
            return ClientLockImpl.LockAcquireResult.UNKNOWN;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PendingLockHold) {
                return super.equals(o) && this.level.equals((Object)((PendingLockHold)o).level);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 5 * super.hashCode() ^ 7 * this.level.hashCode();
        }

        @Override
        public String toString() {
            return super.toString() + " : " + (Object)((Object)this.getLockLevel()) + " : delegated=" + !this.canDelegate() + ", awarded=" + this.isAwarded() + ", refused=" + this.isRefused() + ", " + this.delegationMethod;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID node) {
            ServerLockLevel serverLevel = ServerLockLevel.fromClientLockLevel(this.getLockLevel());
            if (this.isAwarded()) {
                switch (serverLevel) {
                    case READ: {
                        return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.HOLDER_READ);
                    }
                    case WRITE: {
                        return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.HOLDER_WRITE);
                    }
                }
                throw new AssertionError((Object)serverLevel);
            }
            switch (serverLevel) {
                case READ: {
                    return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.PENDING_READ);
                }
                case WRITE: {
                    return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.PENDING_WRITE);
                }
            }
            throw new AssertionError((Object)serverLevel);
        }

        public void allowDelegation() {
            this.delegates = true;
        }
    }

    static class LockHold
    extends LockStateNode {
        private final LockLevel level;
        private boolean flushInProgress = false;

        LockHold(ThreadID owner, LockLevel level) {
            super(owner);
            this.level = level;
        }

        LockLevel getLockLevel() {
            return this.level;
        }

        public void flushInProgress() {
            this.flushInProgress = true;
        }

        public void flushCompleted() {
            this.flushInProgress = false;
        }

        public boolean isFlushInProgress() {
            return this.flushInProgress;
        }

        @Override
        ClientLockImpl.LockAcquireResult allowsHold(LockHold newHold) {
            if (this.getOwner().equals(newHold.getOwner())) {
                if (this.getLockLevel().isWrite()) {
                    return ClientLockImpl.LockAcquireResult.SUCCESS;
                }
                if (newHold.getLockLevel().isRead()) {
                    return ClientLockImpl.LockAcquireResult.SHARED_SUCCESS;
                }
            } else if (this.getLockLevel().isWrite() || newHold.getLockLevel().isWrite()) {
                return ClientLockImpl.LockAcquireResult.FAILURE;
            }
            return ClientLockImpl.LockAcquireResult.UNKNOWN;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof LockHold) {
                return super.equals(o) && this.level.equals((Object)((LockHold)o).level);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 5 * super.hashCode() ^ 7 * this.level.hashCode();
        }

        @Override
        public String toString() {
            return super.toString() + " : " + (Object)((Object)this.level) + " flushInProgress : " + this.flushInProgress;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID node) {
            ServerLockLevel serverLevel = ServerLockLevel.fromClientLockLevel(this.getLockLevel());
            switch (serverLevel) {
                case READ: {
                    return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.HOLDER_READ);
                }
                case WRITE: {
                    return new ClientServerExchangeLockContext(lock, node, this.getOwner(), ServerLockContext.State.HOLDER_WRITE);
                }
            }
            throw new AssertionError((Object)serverLevel);
        }
    }
}

