/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.entity.map;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.map.ValueCodec;
import org.terracotta.entity.map.ValueCodecFactory;
import org.terracotta.entity.map.common.BooleanResponse;
import org.terracotta.entity.map.common.ClearOperation;
import org.terracotta.entity.map.common.ConcurrentClusteredMap;
import org.terracotta.entity.map.common.ConditionalRemoveOperation;
import org.terracotta.entity.map.common.ConditionalReplaceOperation;
import org.terracotta.entity.map.common.ContainsKeyOperation;
import org.terracotta.entity.map.common.ContainsValueOperation;
import org.terracotta.entity.map.common.EntrySetOperation;
import org.terracotta.entity.map.common.EntrySetResponse;
import org.terracotta.entity.map.common.GetOperation;
import org.terracotta.entity.map.common.KeySetOperation;
import org.terracotta.entity.map.common.KeySetResponse;
import org.terracotta.entity.map.common.MapOperation;
import org.terracotta.entity.map.common.MapResponse;
import org.terracotta.entity.map.common.MapValueResponse;
import org.terracotta.entity.map.common.PutAllOperation;
import org.terracotta.entity.map.common.PutIfAbsentOperation;
import org.terracotta.entity.map.common.PutIfPresentOperation;
import org.terracotta.entity.map.common.PutOperation;
import org.terracotta.entity.map.common.RemoveOperation;
import org.terracotta.entity.map.common.SizeOperation;
import org.terracotta.entity.map.common.SizeResponse;
import org.terracotta.entity.map.common.ValueCollectionResponse;
import org.terracotta.entity.map.common.ValuesOperation;

class TerracottaClusteredMap<K, V>
implements ConcurrentClusteredMap<K, V> {
    private final EntityClientEndpoint<MapOperation, MapResponse> endpoint;
    private Class<K> keyClass;
    private Class<V> valueClass;
    private ValueCodec<K> keyValueCodec;
    private ValueCodec<V> valueValueCodec;

    TerracottaClusteredMap(EntityClientEndpoint<MapOperation, MapResponse> endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setTypes(Class<K> keyClass, Class<V> valueClass) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.keyValueCodec = ValueCodecFactory.getCodecForClass(keyClass);
        this.valueValueCodec = ValueCodecFactory.getCodecForClass(valueClass);
    }

    @Override
    public void close() {
        this.endpoint.close();
    }

    @Override
    public int size() {
        Long size = ((SizeResponse)this.invokeWithReturn(new SizeOperation())).getSize();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (size <= 0L) {
            return 0;
        }
        return size.intValue();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.keyClass.isAssignableFrom(key.getClass())) {
            return false;
        }
        return ((BooleanResponse)this.invokeWithReturn(new ContainsKeyOperation(this.keyValueCodec.encode(key)))).isTrue();
    }

    @Override
    public boolean containsValue(Object value) {
        if (!this.valueClass.isAssignableFrom(value.getClass())) {
            return false;
        }
        return ((BooleanResponse)this.invokeWithReturn(new ContainsValueOperation(this.valueValueCodec.encode(value)))).isTrue();
    }

    @Override
    public V get(Object key) {
        if (!this.keyClass.isAssignableFrom(key.getClass())) {
            return null;
        }
        MapValueResponse response = (MapValueResponse)this.invokeWithReturn(new GetOperation(this.keyValueCodec.encode(key)));
        return this.valueValueCodec.decode(response.getValue());
    }

    @Override
    public V put(K key, V value) {
        MapValueResponse response = (MapValueResponse)this.invokeWithReturn(new PutOperation(this.keyValueCodec.encode(key), this.valueValueCodec.encode(value)));
        return this.valueValueCodec.decode(response.getValue());
    }

    @Override
    public V remove(Object key) {
        if (!this.keyClass.isAssignableFrom(key.getClass())) {
            return null;
        }
        MapValueResponse mapValueResponse = (MapValueResponse)this.invokeWithReturn(new RemoveOperation(this.keyValueCodec.encode(key)));
        return this.valueValueCodec.decode(mapValueResponse.getValue());
    }

    private MapResponse invokeWithReturn(MapOperation operation) {
        try {
            return this.endpoint.beginInvoke().message(operation).replicate(operation.operationType().replicate()).invoke().get();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while processing map operation " + operation, e);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        HashMap<Object, Object> input = new HashMap<Object, Object>();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            input.put(this.keyValueCodec.encode(entry.getKey()), this.valueValueCodec.encode(entry.getValue()));
        }
        this.invokeWithReturn(new PutAllOperation(input));
    }

    @Override
    public void clear() {
        this.invokeWithReturn(new ClearOperation());
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> result = new HashSet<K>();
        KeySetResponse keySetResponse = (KeySetResponse)this.invokeWithReturn(new KeySetOperation());
        for (Object o : keySetResponse.getKeySet()) {
            result.add(this.keyValueCodec.decode(o));
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        ValueCollectionResponse response = (ValueCollectionResponse)this.invokeWithReturn(new ValuesOperation());
        for (Object o : response.getValues()) {
            result.add(this.valueValueCodec.decode(o));
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        EntrySetResponse response = (EntrySetResponse)this.invokeWithReturn(new EntrySetOperation());
        for (Map.Entry<Object, Object> entry : response.getEntrySet()) {
            result.add(new AbstractMap.SimpleEntry<K, V>(this.keyValueCodec.decode(entry.getKey()), this.valueValueCodec.decode(entry.getValue())));
        }
        return result;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        MapValueResponse response = (MapValueResponse)this.invokeWithReturn(new PutIfAbsentOperation(this.keyValueCodec.encode(key), this.valueValueCodec.encode(value)));
        return this.valueValueCodec.decode(response.getValue());
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (!this.keyClass.isAssignableFrom(key.getClass())) {
            return false;
        }
        if (!this.valueClass.isAssignableFrom(value.getClass())) {
            return false;
        }
        ConditionalRemoveOperation operation = new ConditionalRemoveOperation(this.keyValueCodec.encode(key), this.valueValueCodec.encode(value));
        return ((BooleanResponse)this.invokeWithReturn(operation)).isTrue();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        ConditionalReplaceOperation operation = new ConditionalReplaceOperation(this.keyValueCodec.encode(key), this.valueValueCodec.encode(oldValue), this.valueValueCodec.encode(newValue));
        return ((BooleanResponse)this.invokeWithReturn(operation)).isTrue();
    }

    @Override
    public V replace(K key, V value) {
        PutIfPresentOperation operation = new PutIfPresentOperation(this.keyValueCodec.encode(key), this.valueValueCodec.encode(value));
        MapValueResponse response = (MapValueResponse)this.invokeWithReturn(operation);
        return this.valueValueCodec.decode(response.getValue());
    }
}

