/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.CodecUtil;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.store.Util;

class ResponseCodec {
    private static final byte OP_CODE_SIZE = 1;
    private final ChainCodec chainCodec = new ChainCodec();

    ResponseCodec() {
    }

    public byte[] encode(EhcacheEntityResponse response) {
        switch (response.getType()) {
            case FAILURE: {
                EhcacheEntityResponse.Failure failure = (EhcacheEntityResponse.Failure)response;
                byte[] failureMsg = Util.marshall(failure.getCause());
                ByteBuffer buffer = ByteBuffer.allocate(1 + failureMsg.length);
                buffer.put(EhcacheEntityResponse.Type.FAILURE.getOpCode());
                buffer.put(failureMsg);
                return buffer.array();
            }
            case SUCCESS: {
                ByteBuffer buffer = ByteBuffer.allocate(1);
                buffer.put(EhcacheEntityResponse.Type.SUCCESS.getOpCode());
                return buffer.array();
            }
            case GET_RESPONSE: {
                EhcacheEntityResponse.GetResponse getResponse = (EhcacheEntityResponse.GetResponse)response;
                byte[] encodedChain = this.chainCodec.encode(getResponse.getChain());
                int chainLen = encodedChain.length;
                ByteBuffer buffer = ByteBuffer.allocate(1 + chainLen);
                buffer.put(EhcacheEntityResponse.Type.GET_RESPONSE.getOpCode());
                buffer.put(encodedChain);
                return buffer.array();
            }
            case HASH_INVALIDATION_DONE: {
                EhcacheEntityResponse.HashInvalidationDone hashInvalidationDone = (EhcacheEntityResponse.HashInvalidationDone)response;
                ByteBuffer buffer = ByteBuffer.allocate(1 + hashInvalidationDone.getCacheId().length() * 2 + 8);
                buffer.put(EhcacheEntityResponse.Type.HASH_INVALIDATION_DONE.getOpCode());
                CodecUtil.putStringAsCharArray(buffer, hashInvalidationDone.getCacheId());
                buffer.putLong(hashInvalidationDone.getKey());
                return buffer.array();
            }
            case ALL_INVALIDATION_DONE: {
                EhcacheEntityResponse.AllInvalidationDone allInvalidationDone = (EhcacheEntityResponse.AllInvalidationDone)response;
                ByteBuffer buffer = ByteBuffer.allocate(1 + allInvalidationDone.getCacheId().length() * 2);
                buffer.put(EhcacheEntityResponse.Type.ALL_INVALIDATION_DONE.getOpCode());
                CodecUtil.putStringAsCharArray(buffer, allInvalidationDone.getCacheId());
                return buffer.array();
            }
            case CLIENT_INVALIDATE_HASH: {
                EhcacheEntityResponse.ClientInvalidateHash clientInvalidateHash = (EhcacheEntityResponse.ClientInvalidateHash)response;
                ByteBuffer buffer = ByteBuffer.allocate(1 + clientInvalidateHash.getCacheId().length() * 2 + 12);
                buffer.put(EhcacheEntityResponse.Type.CLIENT_INVALIDATE_HASH.getOpCode());
                CodecUtil.putStringAsCharArray(buffer, clientInvalidateHash.getCacheId());
                buffer.putLong(clientInvalidateHash.getKey());
                buffer.putInt(((EhcacheEntityResponse.ClientInvalidateHash)response).getInvalidationId());
                return buffer.array();
            }
            case CLIENT_INVALIDATE_ALL: {
                EhcacheEntityResponse.ClientInvalidateAll clientInvalidateAll = (EhcacheEntityResponse.ClientInvalidateAll)response;
                ByteBuffer buffer = ByteBuffer.allocate(1 + clientInvalidateAll.getCacheId().length() * 2 + 4);
                buffer.put(EhcacheEntityResponse.Type.CLIENT_INVALIDATE_ALL.getOpCode());
                CodecUtil.putStringAsCharArray(buffer, clientInvalidateAll.getCacheId());
                buffer.putInt(((EhcacheEntityResponse.ClientInvalidateAll)response).getInvalidationId());
                return buffer.array();
            }
            case SERVER_INVALIDATE_HASH: {
                EhcacheEntityResponse.ServerInvalidateHash serverInvalidateHash = (EhcacheEntityResponse.ServerInvalidateHash)response;
                ByteBuffer buffer = ByteBuffer.allocate(1 + serverInvalidateHash.getCacheId().length() * 2 + 8);
                buffer.put(EhcacheEntityResponse.Type.SERVER_INVALIDATE_HASH.getOpCode());
                CodecUtil.putStringAsCharArray(buffer, serverInvalidateHash.getCacheId());
                buffer.putLong(serverInvalidateHash.getKey());
                return buffer.array();
            }
        }
        throw new UnsupportedOperationException("The operation is not supported : " + (Object)((Object)response.getType()));
    }

    public EhcacheEntityResponse decode(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        byte opCode = buffer.get();
        EhcacheEntityResponse.Type type = EhcacheEntityResponse.Type.responseType(opCode);
        byte[] payArr = new byte[buffer.remaining()];
        buffer.get(payArr);
        switch (type) {
            case SUCCESS: {
                return EhcacheEntityResponse.Success.INSTANCE;
            }
            case FAILURE: {
                Exception exception = (Exception)Util.unmarshall(payArr);
                return new EhcacheEntityResponse.Failure(exception);
            }
            case GET_RESPONSE: {
                return new EhcacheEntityResponse.GetResponse(this.chainCodec.decode(payArr));
            }
            case HASH_INVALIDATION_DONE: {
                String cacheId = ByteBuffer.wrap(payArr, 0, payArr.length - 8).asCharBuffer().toString();
                long key = ByteBuffer.wrap(payArr, payArr.length - 8, 8).getLong();
                return EhcacheEntityResponse.hashInvalidationDone(cacheId, key);
            }
            case ALL_INVALIDATION_DONE: {
                String cacheId = ByteBuffer.wrap(payArr).asCharBuffer().toString();
                return EhcacheEntityResponse.allInvalidationDone(cacheId);
            }
            case CLIENT_INVALIDATE_HASH: {
                String cacheId = ByteBuffer.wrap(payArr, 0, payArr.length - 12).asCharBuffer().toString();
                ByteBuffer byteBuffer = ByteBuffer.wrap(payArr, payArr.length - 12, 12);
                long key = byteBuffer.getLong();
                int invalidationId = byteBuffer.getInt();
                return EhcacheEntityResponse.clientInvalidateHash(cacheId, key, invalidationId);
            }
            case CLIENT_INVALIDATE_ALL: {
                String cacheId = ByteBuffer.wrap(payArr, 0, payArr.length - 4).asCharBuffer().toString();
                ByteBuffer byteBuffer = ByteBuffer.wrap(payArr, payArr.length - 4, 4);
                int invalidationId = byteBuffer.getInt();
                return EhcacheEntityResponse.clientInvalidateAll(cacheId, invalidationId);
            }
            case SERVER_INVALIDATE_HASH: {
                String cacheId = ByteBuffer.wrap(payArr, 0, payArr.length - 8).asCharBuffer().toString();
                ByteBuffer byteBuffer = ByteBuffer.wrap(payArr, payArr.length - 8, 8);
                long key = byteBuffer.getLong();
                return EhcacheEntityResponse.serverInvalidateHash(cacheId, key);
            }
        }
        throw new UnsupportedOperationException("The operation is not supported with opCode : " + (Object)((Object)type));
    }
}

