/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.store.Util;

class LifeCycleMessageCodec {
    private static final byte OPCODE_SIZE = 1;

    LifeCycleMessageCodec() {
    }

    public byte[] encode(LifecycleMessage message) {
        byte[] encodedMsg = Util.marshall(message);
        ByteBuffer buffer = ByteBuffer.allocate(1 + encodedMsg.length);
        buffer.put(message.getOpCode());
        buffer.put(encodedMsg);
        return buffer.array();
    }

    public EhcacheEntityMessage decode(byte[] payload) {
        ByteBuffer message = ByteBuffer.wrap(payload);
        byte[] encodedMsg = new byte[message.capacity() - 1];
        byte opCode = message.get();
        if (opCode == 1) {
            message.get(encodedMsg, 0, encodedMsg.length);
            EhcacheEntityMessage entityMessage = (EhcacheEntityMessage)Util.unmarshall(encodedMsg);
            return entityMessage;
        }
        throw new IllegalArgumentException("LifeCycleMessage operation not defined for : " + opCode);
    }
}

