/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ehcache.clustered.client.internal.EhcacheClientEntity;
import org.ehcache.clustered.client.internal.store.NoInvalidationServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.ServerStoreMessageFactory;
import org.ehcache.clustered.common.internal.store.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventualServerStoreProxy
implements ServerStoreProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventualServerStoreProxy.class);
    private final ServerStoreProxy delegate;
    private final List<ServerStoreProxy.InvalidationListener> invalidationListeners = new CopyOnWriteArrayList<ServerStoreProxy.InvalidationListener>();

    public EventualServerStoreProxy(final ServerStoreMessageFactory messageFactory, EhcacheClientEntity entity) {
        this.delegate = new NoInvalidationServerStoreProxy(messageFactory, entity);
        entity.addResponseListener(EhcacheEntityResponse.ServerInvalidateHash.class, new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.ServerInvalidateHash>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ServerInvalidateHash response) {
                if (response.getCacheId().equals(messageFactory.getCacheId())) {
                    long key = response.getKey();
                    LOGGER.debug("CLIENT: on cache {}, server requesting hash {} to be invalidated", (Object)messageFactory.getCacheId(), (Object)key);
                    for (ServerStoreProxy.InvalidationListener listener : EventualServerStoreProxy.this.invalidationListeners) {
                        listener.onInvalidateHash(key);
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
        entity.addResponseListener(EhcacheEntityResponse.ClientInvalidateHash.class, new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.ClientInvalidateHash>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ClientInvalidateHash response) {
                String cacheId = response.getCacheId();
                long key = response.getKey();
                int invalidationId = response.getInvalidationId();
                if (cacheId.equals(messageFactory.getCacheId())) {
                    LOGGER.debug("CLIENT: doing work to invalidate hash {} from cache {} (ID {})", new Object[]{key, cacheId, invalidationId});
                    for (ServerStoreProxy.InvalidationListener listener : EventualServerStoreProxy.this.invalidationListeners) {
                        listener.onInvalidateHash(key);
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
        entity.addResponseListener(EhcacheEntityResponse.ClientInvalidateAll.class, new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.ClientInvalidateAll>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ClientInvalidateAll response) {
                String cacheId = response.getCacheId();
                int invalidationId = response.getInvalidationId();
                if (cacheId.equals(messageFactory.getCacheId())) {
                    LOGGER.debug("CLIENT: doing work to invalidate all from cache {} (ID {})", (Object)cacheId, (Object)invalidationId);
                    for (ServerStoreProxy.InvalidationListener listener : EventualServerStoreProxy.this.invalidationListeners) {
                        listener.onInvalidateAll();
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
    }

    @Override
    public String getCacheId() {
        return this.delegate.getCacheId();
    }

    @Override
    public void addInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        this.invalidationListeners.add(listener);
    }

    @Override
    public boolean removeInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        return this.invalidationListeners.remove(listener);
    }

    @Override
    public Chain get(long key) {
        return this.delegate.get(key);
    }

    @Override
    public void append(long key, ByteBuffer payLoad) {
        this.delegate.append(key, payLoad);
    }

    @Override
    public Chain getAndAppend(long key, ByteBuffer payLoad) {
        return this.delegate.getAndAppend(key, payLoad);
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        this.delegate.replaceAtHead(key, expect, update);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

