/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.core.TCConnection;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.IllegalReconnectException;
import com.tc.net.protocol.NetworkStackHarness;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.ProtocolAdaptorFactory;
import com.tc.net.protocol.RejectReconnectionException;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.tcm.msgs.CommsMessageFactory;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.NetworkStackProvider;
import com.tc.net.protocol.transport.SynMessage;
import com.tc.net.protocol.transport.TransportHandshakeErrorContext;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeMessage;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactory;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.util.Assert;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class ServerStackProvider
implements NetworkStackProvider,
MessageTransportListener,
ProtocolAdaptorFactory {
    private static final TCLogger logger = TCLogging.getLogger(ServerStackProvider.class);
    private final Map<ConnectionID, NetworkStackHarness> harnesses = new ConcurrentHashMap<ConnectionID, NetworkStackHarness>();
    private final NetworkStackHarnessFactory harnessFactory;
    private final ServerMessageChannelFactory channelFactory;
    private final TransportHandshakeMessageFactory handshakeMessageFactory;
    private final ConnectionIDFactory connectionIdFactory;
    private final ConnectionPolicy connectionPolicy;
    private final WireProtocolAdaptorFactory wireProtocolAdaptorFactory;
    private final WireProtocolMessageSink wireProtoMsgsink;
    private final TCSecurityManager securityManager;
    private final MessageTransportFactory messageTransportFactory;
    private final List<MessageTransportListener> transportListeners = new ArrayList<MessageTransportListener>();
    private final ReentrantLock licenseLock;
    private final String commsMgrName;

    public ServerStackProvider(Set<ConnectionID> initialConnectionIDs, NetworkStackHarnessFactory harnessFactory, ServerMessageChannelFactory channelFactory, MessageTransportFactory messageTransportFactory, TransportHandshakeMessageFactory handshakeMessageFactory, ConnectionIDFactory connectionIdFactory, ConnectionPolicy connectionPolicy, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, ReentrantLock licenseLock) {
        this(initialConnectionIDs, harnessFactory, channelFactory, messageTransportFactory, handshakeMessageFactory, connectionIdFactory, connectionPolicy, wireProtocolAdaptorFactory, null, licenseLock, "L2_L1", null);
    }

    public ServerStackProvider(Set<ConnectionID> initialConnectionIDs, NetworkStackHarnessFactory harnessFactory, ServerMessageChannelFactory channelFactory, MessageTransportFactory messageTransportFactory, TransportHandshakeMessageFactory handshakeMessageFactory, ConnectionIDFactory connectionIdFactory, ConnectionPolicy connectionPolicy, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, WireProtocolMessageSink wireProtoMsgSink, ReentrantLock licenseLock, String commsMgrName, TCSecurityManager securityManager) {
        this.messageTransportFactory = messageTransportFactory;
        this.connectionPolicy = connectionPolicy;
        this.wireProtocolAdaptorFactory = wireProtocolAdaptorFactory;
        this.wireProtoMsgsink = wireProtoMsgSink;
        this.securityManager = securityManager;
        Assert.assertNotNull(harnessFactory);
        this.harnessFactory = harnessFactory;
        this.channelFactory = channelFactory;
        this.handshakeMessageFactory = handshakeMessageFactory;
        this.connectionIdFactory = connectionIdFactory;
        this.transportListeners.add(this);
        Assert.assertNotNull(licenseLock);
        this.licenseLock = licenseLock;
        this.commsMgrName = commsMgrName;
        Iterator<ConnectionID> i$ = initialConnectionIDs.iterator();
        while (i$.hasNext()) {
            ConnectionID initialConnectionID;
            ConnectionID connectionID = initialConnectionID = i$.next();
            logger.info("Preparing comms stack for previously connected client: " + connectionID);
            this.newStackHarness(connectionID, messageTransportFactory.createNewTransport(connectionID, this.createHandshakeErrorHandler(), handshakeMessageFactory, this.transportListeners));
        }
    }

    @Override
    public MessageTransport attachNewConnection(ConnectionID connectionId, TCConnection connection) throws RejectReconnectionException {
        MessageTransport rv;
        Assert.assertNotNull(connection);
        if (connectionId.isNewConnection()) {
            ConnectionID ourConnectionId = this.connectionIdFactory.populateConnectionID(connectionId);
            rv = this.messageTransportFactory.createNewTransport(ourConnectionId, connection, this.createHandshakeErrorHandler(), this.handshakeMessageFactory, this.transportListeners);
            this.newStackHarness(ourConnectionId, rv);
        } else {
            NetworkStackHarness harness = this.harnesses.get(connectionId);
            if (harness == null) {
                throw new RejectReconnectionException("Stack for " + connectionId + " not found.", connection.getRemoteAddress());
            }
            try {
                rv = harness.attachNewConnection(connection);
            }
            catch (IllegalReconnectException e) {
                logger.warn("Client attempting an illegal reconnect for id " + connectionId + ", " + connection);
                throw new RejectReconnectionException("Illegal reconnect attempt from " + connectionId + ".", connection.getRemoteAddress());
            }
            this.connectionIdFactory.restoreConnectionId(connectionId);
        }
        return rv;
    }

    private void newStackHarness(ConnectionID id, MessageTransport transport) {
        NetworkStackHarness harness = this.harnessFactory.createServerHarness(this.channelFactory, transport, new MessageTransportListener[]{this});
        harness.finalizeStack();
        NetworkStackHarness previous = this.harnesses.put(id, harness);
        if (previous != null) {
            throw new AssertionError((Object)("previous is " + previous + "connectionID:" + id + "new is" + harness));
        }
    }

    private TransportHandshakeErrorHandler createHandshakeErrorHandler() {
        return new TransportHandshakeErrorHandler(){

            @Override
            public void handleHandshakeError(TransportHandshakeErrorContext thec) {
                logger.info(thec.getMessage());
            }
        };
    }

    NetworkStackHarness removeNetworkStack(ConnectionID connectionId) {
        return this.harnesses.remove(connectionId);
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        this.connectionPolicy.clientDisconnected(transport.getConnectionId());
    }

    private void close(ConnectionID connectionId) {
        NetworkStackHarness harness = this.removeNetworkStack(connectionId);
        if (harness == null) {
            throw new AssertionError((Object)("Receive a transport closed event for a transport that isn't in the map :" + connectionId));
        }
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        this.close(transport.getConnectionId());
        if (!transport.getConnectionId().isJvmIDNull()) {
            this.connectionPolicy.clientDisconnected(transport.getConnectionId());
        }
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
    }

    @Override
    public TCProtocolAdaptor getInstance() {
        if (this.wireProtoMsgsink != null) {
            return this.wireProtocolAdaptorFactory.newWireProtocolAdaptor(this.wireProtoMsgsink);
        }
        MessageSink sink = new MessageSink(this.createHandshakeErrorHandler(), this.commsMgrName);
        return this.wireProtocolAdaptorFactory.newWireProtocolAdaptor(sink);
    }

    class MessageSink
    implements WireProtocolMessageSink {
        private final TransportHandshakeErrorHandler handshakeErrorHandler;
        private final String commsManagerName;
        private volatile boolean isSynReceived = false;
        private volatile boolean isHandshakeError = false;
        private volatile MessageTransport transport;

        private MessageSink(TransportHandshakeErrorHandler handshakeErrorHandler, String commsMgrName) {
            this.handshakeErrorHandler = handshakeErrorHandler;
            this.commsManagerName = commsMgrName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putMessage(WireProtocolMessage message) {
            if (!this.isSynReceived) {
                MessageSink messageSink = this;
                synchronized (messageSink) {
                    if (!this.isSynReceived) {
                        this.isSynReceived = this.verifyAndHandleSyn(message);
                        message.recycle();
                        return;
                    }
                }
            }
            if (!this.isHandshakeError) {
                this.transport.receiveTransportMessage(message);
            }
        }

        private boolean verifyAndHandleSyn(WireProtocolMessage message) {
            boolean isSynced = false;
            if (!this.verifySyn(message)) {
                this.handleHandshakeError(new TransportHandshakeErrorContext("Expected a SYN message but received: " + message, 1));
            } else {
                try {
                    this.handleSyn((SynMessage)message);
                    isSynced = true;
                }
                catch (RejectReconnectionException e) {
                    String errorMessage = CommsMessageFactory.createReconnectRejectMessage(this.commsManagerName, new Object[]{e.getMessage()});
                    this.transport = ServerStackProvider.this.messageTransportFactory.createNewTransport(((SynMessage)message).getConnectionId(), ((SynMessage)message).getSource(), ServerStackProvider.this.createHandshakeErrorHandler(), ServerStackProvider.this.handshakeMessageFactory, ServerStackProvider.this.transportListeners);
                    this.sendSynAck(((SynMessage)message).getConnectionId(), new TransportHandshakeErrorContext(errorMessage, 6), ((SynMessage)message).getSource(), false);
                    this.handleHandshakeError(new TransportHandshakeErrorContext(errorMessage, e));
                }
            }
            return isSynced;
        }

        private void handleHandshakeError(TransportHandshakeErrorContext ctxt) {
            this.isHandshakeError = true;
            this.handshakeErrorHandler.handleHandshakeError(ctxt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSyn(SynMessage syn) throws RejectReconnectionException {
            ConnectionID connectionId = syn.getConnectionId();
            boolean isMaxConnectionReached = false;
            if (connectionId == null) {
                this.transport = ServerStackProvider.this.messageTransportFactory.createNewTransport(connectionId, syn.getSource(), ServerStackProvider.this.createHandshakeErrorHandler(), ServerStackProvider.this.handshakeMessageFactory, ServerStackProvider.this.transportListeners);
                this.sendSynAck(new TransportHandshakeErrorContext("Invalid connection id: " + connectionId, 2), syn.getSource(), isMaxConnectionReached);
                this.isHandshakeError = true;
                return;
            }
            ServerStackProvider.this.licenseLock.lock();
            try {
                if (connectionId.isNewConnection() && !ServerStackProvider.this.connectionPolicy.isConnectAllowed(connectionId)) {
                    isMaxConnectionReached = true;
                    this.transport = ServerStackProvider.this.messageTransportFactory.createNewTransport(connectionId, syn.getSource(), ServerStackProvider.this.createHandshakeErrorHandler(), ServerStackProvider.this.handshakeMessageFactory, ServerStackProvider.this.transportListeners);
                } else {
                    this.transport = ServerStackProvider.this.attachNewConnection(connectionId, syn.getSource());
                    ConnectionID sentConnectionId = connectionId;
                    ConnectionID transportConnectionId = this.transport.getConnectionId();
                    connectionId = new ConnectionID(sentConnectionId.getJvmID(), transportConnectionId.getChannelID(), transportConnectionId.getServerID(), sentConnectionId.getUsername(), sentConnectionId.getPassword(), sentConnectionId.getProductId());
                    if (transportConnectionId.isJvmIDNull()) {
                        this.transport.initConnectionID(new ConnectionID(sentConnectionId.getJvmID(), connectionId.getChannelID(), connectionId.getServerID()));
                    }
                    isMaxConnectionReached = !ServerStackProvider.this.connectionPolicy.connectClient(connectionId);
                }
            }
            finally {
                ServerStackProvider.this.licenseLock.unlock();
            }
            this.transport.setRemoteCallbackPort(syn.getCallbackPort());
            short clientStackLayerFlags = syn.getStackLayerFlags();
            short serverStackLayerFlags = this.transport.getCommunicationStackFlags(this.transport);
            if (!isMaxConnectionReached && clientStackLayerFlags != serverStackLayerFlags) {
                String layersPresentInServer = "Layers Present in Server side communication stack: ";
                layersPresentInServer = layersPresentInServer + this.transport.getCommunicationStackNames(this.transport);
                this.sendSynAck(connectionId, new TransportHandshakeErrorContext(layersPresentInServer, 3), syn.getSource(), isMaxConnectionReached);
                if ((serverStackLayerFlags & 2) != 0) {
                    logger.error("Once and Only Once Protocol Layer is present in server but not in client");
                } else {
                    logger.error("Once and Only Once Protocol Layer is present in client but not in server");
                }
                this.isHandshakeError = true;
                return;
            }
            Principal principal = null;
            if (ServerStackProvider.this.securityManager != null) {
                if (!connectionId.isSecured()) {
                    logger.fatal("Security is enabled here on the server, but we didn't get credentials on the handshake!");
                    this.isHandshakeError = true;
                    return;
                }
                principal = ServerStackProvider.this.securityManager.authenticate(connectionId.getUsername(), connectionId.getPassword());
                if (principal == null) {
                    logger.fatal("Authentication failed for user " + connectionId.getUsername() + " with pw (" + connectionId.getPassword().length + "): " + new String(connectionId.getPassword()));
                    this.isHandshakeError = true;
                    return;
                }
            }
            logger.info("User " + principal + " successfully authenticated");
            this.sendSynAck(connectionId, syn.getSource(), isMaxConnectionReached);
        }

        private boolean verifySyn(WireProtocolMessage message) {
            return message instanceof TransportHandshakeMessage && ((TransportHandshakeMessage)message).isSyn();
        }

        private void sendSynAck(ConnectionID connectionId, TCConnection source, boolean isMaxConnectionReached) {
            source.addWeight(1);
            this.sendSynAck(connectionId, null, source, isMaxConnectionReached);
        }

        private void sendSynAck(TransportHandshakeErrorContext errorContext, TCConnection source, boolean isMaxConnectionsReached) {
            Assert.eval(errorContext != null);
            this.sendSynAck(null, errorContext, source, isMaxConnectionsReached);
        }

        private void sendSynAck(ConnectionID connectionId, TransportHandshakeErrorContext errorContext, TCConnection source, boolean isMaxConnectionsReached) {
            TransportHandshakeMessage synAck;
            boolean isError = errorContext != null;
            int maxConnections = ServerStackProvider.this.connectionPolicy.getMaxConnections();
            if (isError) {
                synAck = ServerStackProvider.this.handshakeMessageFactory.createSynAck(connectionId, errorContext, source, isMaxConnectionsReached, maxConnections);
            } else {
                int callbackPort = source.getLocalAddress().getPort();
                synAck = ServerStackProvider.this.handshakeMessageFactory.createSynAck(connectionId, source, isMaxConnectionsReached, maxConnections, callbackPort);
            }
            this.sendMessage(synAck);
        }

        private void sendMessage(WireProtocolMessage message) {
            this.transport.sendToConnection(message);
        }
    }
}

