/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.logging.TCLogger;
import com.tc.net.protocol.transport.MessageTransportState;
import com.tc.util.Assert;

class MessageTransportStatus {
    private MessageTransportState state;
    private TCLogger logger;

    MessageTransportStatus(MessageTransportState initialState, TCLogger logger) {
        this.state = initialState;
        this.logger = logger;
    }

    synchronized void reset() {
        this.state = MessageTransportState.STATE_START;
    }

    private void stateChange(MessageTransportState newState) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Changing from " + this.state.toString() + " to " + newState.toString());
        }
        if (this.isEnd()) {
            Assert.eval("Transport StateChange from END state not allowed", newState != MessageTransportState.STATE_END);
            this.logger.warn("Unexpected Transport StateChange attempt. Changing from " + this.state.toString() + " to " + newState.toString(), new Throwable());
        }
        this.state = newState;
    }

    synchronized void synSent() {
        this.stateChange(MessageTransportState.STATE_SYN_SENT);
    }

    synchronized void synAckError() {
        this.stateChange(MessageTransportState.STATE_SYN_ACK_ERROR);
    }

    synchronized void established() {
        this.stateChange(MessageTransportState.STATE_ESTABLISHED);
    }

    synchronized void closed() {
        this.stateChange(MessageTransportState.STATE_CLOSED);
    }

    synchronized void disconnect() {
        this.stateChange(MessageTransportState.STATE_DISCONNECTED);
    }

    synchronized void end() {
        this.stateChange(MessageTransportState.STATE_END);
    }

    synchronized boolean isStart() {
        return this.state.equals((Object)MessageTransportState.STATE_START);
    }

    public boolean isRestart() {
        return this.state.equals((Object)MessageTransportState.STATE_RESTART);
    }

    synchronized boolean isSynSent() {
        return this.state.equals((Object)MessageTransportState.STATE_SYN_SENT);
    }

    synchronized boolean isEstablished() {
        return this.state.equals((Object)MessageTransportState.STATE_ESTABLISHED);
    }

    synchronized boolean isDisconnected() {
        return this.state.equals((Object)MessageTransportState.STATE_DISCONNECTED);
    }

    synchronized boolean isClosed() {
        return this.state.equals((Object)MessageTransportState.STATE_CLOSED);
    }

    synchronized boolean isEnd() {
        return this.state.equals((Object)MessageTransportState.STATE_END);
    }

    public String toString() {
        return this.state.toString();
    }
}

