/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.l2.msg.ReplicationMessage;
import com.tc.net.ClientID;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.IOException;

public class PassiveSyncMessage
extends ReplicationMessage {
    public static final long NO_VERSION = 0L;

    public static PassiveSyncMessage createStartSyncMessage() {
        return new PassiveSyncMessage(ReplicationMessage.ReplicationType.SYNC_BEGIN, EntityID.NULL_ID, 0L, 0, null);
    }

    public static PassiveSyncMessage createEndSyncMessage() {
        return new PassiveSyncMessage(ReplicationMessage.ReplicationType.SYNC_END, EntityID.NULL_ID, 0L, 0, null);
    }

    public static PassiveSyncMessage createStartEntityMessage(EntityID id, long version, byte[] configPayload, boolean canDelete) {
        return new PassiveSyncMessage(ReplicationMessage.ReplicationType.SYNC_ENTITY_BEGIN, id, version, canDelete ? 0 : 1, configPayload);
    }

    public static PassiveSyncMessage createEndEntityMessage(EntityID id, long version) {
        return new PassiveSyncMessage(ReplicationMessage.ReplicationType.SYNC_ENTITY_END, id, version, 0, null);
    }

    public static PassiveSyncMessage createStartEntityKeyMessage(EntityID id, long version, int concurrency) {
        Assert.assertTrue(concurrency > 0);
        return new PassiveSyncMessage(ReplicationMessage.ReplicationType.SYNC_ENTITY_CONCURRENCY_BEGIN, id, version, concurrency, null);
    }

    public static PassiveSyncMessage createEndEntityKeyMessage(EntityID id, long version, int concurrency) {
        Assert.assertTrue(concurrency > 0);
        return new PassiveSyncMessage(ReplicationMessage.ReplicationType.SYNC_ENTITY_CONCURRENCY_END, id, version, concurrency, null);
    }

    public static PassiveSyncMessage createPayloadMessage(EntityID id, long version, int concurrency, byte[] payload) {
        Assert.assertTrue(concurrency > 0);
        return new PassiveSyncMessage(ReplicationMessage.ReplicationType.SYNC_ENTITY_CONCURRENCY_PAYLOAD, id, version, concurrency, payload);
    }

    public PassiveSyncMessage() {
        super(2);
    }

    private PassiveSyncMessage(ReplicationMessage.ReplicationType type, EntityID id, long version, int concurrency, byte[] payload) {
        super(2);
        this.initialize(new EntityDescriptor(id, ClientInstanceID.NULL_ID, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, type, payload, concurrency);
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        super.basicDeserializeFrom(in);
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        super.basicSerializeTo(out);
    }

    @Override
    public EntityID getEntityID() {
        return this.getEntityDescriptor().getEntityID();
    }
}

