/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.JsonValue;
import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;

class YassonGenerator
implements JsonGenerator {
    private final JsonGenerator delegate;
    private int level;

    YassonGenerator(JsonGenerator delegate) {
        this.delegate = delegate;
    }

    public JsonGenerator writeStartObject() {
        this.writeValidate("writeStartObject()");
        ++this.level;
        return this.delegate.writeStartObject();
    }

    public JsonGenerator writeStartObject(String name) {
        this.writeValidate("writeStartObject(String name)");
        ++this.level;
        return this.delegate.writeStartObject(name);
    }

    public JsonGenerator writeKey(String name) {
        this.writeValidate("writeKey(String name)");
        ++this.level;
        return this.delegate.writeKey(name);
    }

    public JsonGenerator writeStartArray() {
        this.writeValidate("writeStartArray()");
        ++this.level;
        return this.delegate.writeStartArray();
    }

    public JsonGenerator writeStartArray(String name) {
        this.writeValidate("writeStartArray(String name)");
        ++this.level;
        return this.delegate.writeStartArray(name);
    }

    public JsonGenerator write(String name, JsonValue value) {
        this.writeValidate("write(String name, JsonValue value)");
        return this.delegate.write(name, value);
    }

    public JsonGenerator write(String name, String value) {
        this.writeValidate("write(String name, String value)");
        return this.delegate.write(name, value);
    }

    public JsonGenerator write(String name, BigInteger value) {
        this.writeValidate("write(String name, BigInteger value)");
        return this.delegate.write(name, value);
    }

    public JsonGenerator write(String name, BigDecimal value) {
        this.writeValidate("write(String name, BigDecimal value)");
        return this.delegate.write(name, value);
    }

    public JsonGenerator write(String name, int value) {
        this.writeValidate("write(String name, int value)");
        return this.delegate.write(name, value);
    }

    public JsonGenerator write(String name, long value) {
        this.writeValidate("write(String name, long value)");
        return this.delegate.write(name, value);
    }

    public JsonGenerator write(String name, double value) {
        this.writeValidate("write(String name, double value)");
        return this.delegate.write(name, value);
    }

    public JsonGenerator write(String name, boolean value) {
        this.writeValidate("write(String name, boolean value)");
        return this.delegate.write(name, value);
    }

    public JsonGenerator writeNull(String name) {
        this.writeValidate("writeNull(String name)");
        return this.delegate.writeNull(name);
    }

    public JsonGenerator writeEnd() {
        --this.level;
        if (this.level < 0) {
            throw new JsonbException("writeEnd() cannot be called outside of the scope of user generator.");
        }
        if (this.level == 0) {
            --this.level;
        }
        return this.delegate.writeEnd();
    }

    public JsonGenerator write(JsonValue value) {
        this.writeValidate("write(JsonValue value)");
        --this.level;
        return this.delegate.write(value);
    }

    public JsonGenerator write(String value) {
        this.writeValidate("write(String value)");
        --this.level;
        return this.delegate.write(value);
    }

    public JsonGenerator write(BigDecimal value) {
        this.writeValidate("write(BigDecimal value)");
        --this.level;
        return this.delegate.write(value);
    }

    public JsonGenerator write(BigInteger value) {
        this.writeValidate("write(BigInteger value)");
        --this.level;
        return this.delegate.write(value);
    }

    public JsonGenerator write(int value) {
        this.writeValidate("write(int value)");
        --this.level;
        return this.delegate.write(value);
    }

    public JsonGenerator write(long value) {
        this.writeValidate("write(long value)");
        --this.level;
        return this.delegate.write(value);
    }

    public JsonGenerator write(double value) {
        this.writeValidate("write(double value)");
        --this.level;
        return this.delegate.write(value);
    }

    public JsonGenerator write(boolean value) {
        this.writeValidate("write(boolean value)");
        --this.level;
        return this.delegate.write(value);
    }

    public JsonGenerator writeNull() {
        this.writeValidate("writeNull()");
        --this.level;
        return this.delegate.writeNull();
    }

    public void close() {
        throw new JsonbException("Unsupported operation in user defined deserializer.");
    }

    public void flush() {
        throw new JsonbException("Unsupported operation in user defined deserializer.");
    }

    private void writeValidate(String method) {
        if (this.level < 0) {
            throw new JsonbException(method + " cannot be called outside of the scope of user generator.");
        }
    }
}

