/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.yasson.internal.InstanceCreator;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.RuntimeTypeInfo;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;

class ContainerDeserializerUtils {
    private ContainerDeserializerUtils() {
        throw new IllegalStateException("Util classes cannot be instantiated!");
    }

    public static Type mapKeyType(RuntimeTypeInfo item, Type mapType) {
        return mapType instanceof ParameterizedType ? ReflectionUtils.resolveType(item, ((ParameterizedType)mapType).getActualTypeArguments()[0]) : Object.class;
    }

    public static Type mapValueType(RuntimeTypeInfo item, Type mapType) {
        return mapType instanceof ParameterizedType ? ReflectionUtils.resolveType(item, ((ParameterizedType)mapType).getActualTypeArguments()[1]) : Object.class;
    }

    public static <T extends Map<?, ?>> T createMapInstance(DeserializerBuilder builder, Type mapType) {
        Class<?> rawType = ReflectionUtils.getRawType(mapType);
        if (rawType.isInterface()) {
            if (SortedMap.class.isAssignableFrom(rawType)) {
                Map map;
                Class<?> defaultMapImplType = builder.getJsonbContext().getConfigProperties().getDefaultMapImplType();
                if (SortedMap.class.isAssignableFrom(defaultMapImplType)) {
                    builder.getJsonbContext().getInstanceCreator();
                    map = (Map)InstanceCreator.createInstance(defaultMapImplType);
                } else {
                    map = new TreeMap();
                }
                return (T)map;
            }
            return (T)new HashMap();
        }
        builder.getJsonbContext().getInstanceCreator();
        return (T)((Map)InstanceCreator.createInstance(rawType));
    }

    public static JsonbDeserializer<?> newCollectionOrMapItem(CurrentItem<?> wrapper, Type valueType, JsonbContext ctx, JsonParser.Event event) {
        Type actualValueType = ReflectionUtils.resolveType(wrapper, valueType);
        DeserializerBuilder deserializerBuilder = (DeserializerBuilder)ContainerDeserializerUtils.newUnmarshallerItemBuilder(wrapper, ctx, event).withType(actualValueType);
        if (!DefaultSerializers.getInstance().isKnownType(ReflectionUtils.getRawType(actualValueType))) {
            ClassModel classModel = ctx.getMappingContext().getOrCreateClassModel(ReflectionUtils.getRawType(actualValueType));
            deserializerBuilder.withCustomization(classModel == null ? null : classModel.getClassCustomization());
        }
        return deserializerBuilder.build();
    }

    public static DeserializerBuilder newUnmarshallerItemBuilder(CurrentItem<?> wrapper, JsonbContext ctx, JsonParser.Event event) {
        return ((DeserializerBuilder)new DeserializerBuilder(ctx).withWrapper(wrapper)).withJsonValueType(event);
    }
}

