/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import jakarta.json.bind.config.PropertyNamingStrategy;
import jakarta.json.bind.serializer.JsonbSerializer;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.yasson.internal.AnnotationIntrospector;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.components.SerializerBinding;
import org.eclipse.yasson.internal.model.AnnotationTarget;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.PropertyValuePropagation;
import org.eclipse.yasson.internal.model.ReflectionPropagation;
import org.eclipse.yasson.internal.model.customization.PropertyCustomization;
import org.eclipse.yasson.internal.model.customization.PropertyCustomizationBuilder;
import org.eclipse.yasson.internal.serializer.AdaptedObjectSerializer;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;
import org.eclipse.yasson.internal.serializer.SerializerProviderWrapper;
import org.eclipse.yasson.internal.serializer.UserSerializerSerializer;

public class PropertyModel
implements Comparable<PropertyModel> {
    private final String propertyName;
    private final String readName;
    private final String writeName;
    private final Type propertyType;
    private final ClassModel classModel;
    private final Property property;
    private final PropertyCustomization customization;
    private final PropertyValuePropagation propagation;
    private final JsonbSerializer<?> propertySerializer;
    private final Type getterMethodType;
    private final Type setterMethodType;

    public PropertyModel(PropertyModel a, PropertyModel b) {
        if (!a.equals(b)) {
            throw new IllegalStateException("Property models " + a + " and " + b + " cannot be merged");
        }
        this.classModel = a.classModel;
        this.propertyName = a.propertyName;
        this.readName = a.readName;
        this.writeName = a.writeName;
        this.propertyType = a.propertyType;
        this.customization = a.customization;
        this.getterMethodType = a.getterMethodType != null ? a.getterMethodType : b.getterMethodType;
        this.setterMethodType = a.setterMethodType != null ? a.setterMethodType : b.setterMethodType;
        this.property = a.property;
        if (b.property.getField() != null) {
            this.property.setField(b.property.getField());
        }
        if (b.property.getGetter() != null) {
            this.property.setGetter(b.property.getGetter());
        }
        if (b.property.getSetter() != null) {
            this.property.setSetter(b.property.getSetter());
        }
        this.propagation = new ReflectionPropagation(this.property, this.classModel.getClassCustomization().getPropertyVisibilityStrategy());
        this.propertySerializer = this.resolveCachedSerializer();
    }

    public PropertyModel(ClassModel classModel, Property property, JsonbContext jsonbContext) {
        this.classModel = classModel;
        this.property = property;
        this.propertyName = property.getName();
        this.propertyType = property.getPropertyType();
        this.propagation = new ReflectionPropagation(property, classModel.getClassCustomization().getPropertyVisibilityStrategy());
        this.getterMethodType = this.propagation.isGetterVisible() ? property.getGetterType() : null;
        this.setterMethodType = this.propagation.isSetterVisible() ? property.getSetterType() : null;
        this.customization = this.introspectCustomization(property, jsonbContext);
        this.readName = this.calculateReadWriteName(this.customization.getJsonReadName(), jsonbContext.getConfigProperties().getPropertyNamingStrategy());
        this.writeName = this.calculateReadWriteName(this.customization.getJsonWriteName(), jsonbContext.getConfigProperties().getPropertyNamingStrategy());
        this.propertySerializer = this.resolveCachedSerializer();
    }

    private JsonbSerializer<?> resolveCachedSerializer() {
        Type serializationType = this.getPropertySerializationType();
        if (!ReflectionUtils.isResolvedType(serializationType)) {
            return null;
        }
        if (this.customization.getSerializeAdapterBinding() != null) {
            return new AdaptedObjectSerializer(this.classModel, this.customization.getSerializeAdapterBinding());
        }
        if (this.customization.getSerializerBinding() != null) {
            return new UserSerializerSerializer(this.classModel, this.customization.getSerializerBinding().getJsonbSerializer());
        }
        Class<?> propertyRawType = ReflectionUtils.getRawType(serializationType);
        Optional<SerializerProviderWrapper> valueSerializerProvider = DefaultSerializers.getInstance().findValueSerializerProvider(propertyRawType);
        if (valueSerializerProvider.isPresent()) {
            return valueSerializerProvider.get().getSerializerProvider().provideSerializer(this.customization);
        }
        return null;
    }

    public Type getPropertyDeserializationType() {
        return this.setterMethodType == null ? this.propertyType : this.setterMethodType;
    }

    public Type getPropertySerializationType() {
        return this.getterMethodType == null ? this.propertyType : this.getterMethodType;
    }

    private SerializerBinding<?> getUserSerializerBinding(Property property, JsonbContext jsonbContext) {
        SerializerBinding serializerBinding = jsonbContext.getAnnotationIntrospector().getSerializerBinding(property);
        if (serializerBinding != null) {
            return serializerBinding;
        }
        return jsonbContext.getComponentMatcher().getSerializerBinding(this.getPropertySerializationType(), null).orElse(null);
    }

    private PropertyCustomization introspectCustomization(Property property, JsonbContext jsonbContext) {
        AdapterBinding adapterBinding;
        AnnotationIntrospector introspector = jsonbContext.getAnnotationIntrospector();
        PropertyCustomizationBuilder builder = new PropertyCustomizationBuilder();
        EnumSet<AnnotationTarget> transientInfo = introspector.getJsonbTransientCategorized(property);
        if (transientInfo.size() != 0) {
            builder.setReadTransient(transientInfo.contains((Object)AnnotationTarget.GETTER));
            builder.setWriteTransient(transientInfo.contains((Object)AnnotationTarget.SETTER));
            if (transientInfo.contains((Object)AnnotationTarget.PROPERTY)) {
                if (!transientInfo.contains((Object)AnnotationTarget.GETTER)) {
                    builder.setReadTransient(true);
                }
                if (!transientInfo.contains((Object)AnnotationTarget.SETTER)) {
                    builder.setWriteTransient(true);
                }
            }
            if (builder.isReadTransient()) {
                introspector.checkTransientIncompatible(property.getFieldElement());
                introspector.checkTransientIncompatible(property.getGetterElement());
            }
            if (builder.isWriteTransient()) {
                introspector.checkTransientIncompatible(property.getFieldElement());
                introspector.checkTransientIncompatible(property.getSetterElement());
            }
        }
        if (!builder.isReadTransient()) {
            builder.setJsonWriteName(introspector.getJsonbPropertyJsonWriteName(property));
            builder.setNillable(introspector.isPropertyNillable(property).orElse(this.classModel.getClassCustomization().isNillable()));
            builder.setSerializerBinding(this.getUserSerializerBinding(property, jsonbContext));
        }
        if (!builder.isWriteTransient()) {
            builder.setJsonReadName(introspector.getJsonbPropertyJsonReadName(property));
            builder.setDeserializerBinding(introspector.getDeserializerBinding(property));
        }
        if ((adapterBinding = jsonbContext.getAnnotationIntrospector().getAdapterBinding(property)) != null) {
            builder.setSerializeAdapter(adapterBinding);
            builder.setDeserializeAdapter(adapterBinding);
        } else {
            builder.setSerializeAdapter(jsonbContext.getComponentMatcher().getSerializeAdapterBinding(this.getPropertySerializationType(), null).orElse(null));
            builder.setDeserializeAdapter(jsonbContext.getComponentMatcher().getDeserializeAdapterBinding(this.getPropertyDeserializationType(), null).orElse(null));
        }
        this.introspectDateFormatter(property, introspector, builder, jsonbContext);
        this.introspectNumberFormatter(property, introspector, builder);
        builder.setImplementationClass(introspector.getImplementationClass(property));
        return builder.buildPropertyCustomization();
    }

    private void introspectDateFormatter(Property property, AnnotationIntrospector introspector, PropertyCustomizationBuilder builder, JsonbContext jsonbContext) {
        JsonbDateFormatter dateFormatter;
        Map<AnnotationTarget, JsonbDateFormatter> jsonDateFormatCategorized = introspector.getJsonbDateFormatCategorized(property);
        JsonbDateFormatter configDateFormatter = jsonbContext.getConfigProperties().getConfigDateFormatter();
        if (!builder.isReadTransient()) {
            dateFormatter = this.getTargetForMostPreciseScope(jsonDateFormatCategorized, AnnotationTarget.GETTER, AnnotationTarget.PROPERTY, AnnotationTarget.CLASS);
            builder.setSerializeDateFormatter(dateFormatter != null ? dateFormatter : configDateFormatter);
        }
        if (!builder.isWriteTransient()) {
            dateFormatter = this.getTargetForMostPreciseScope(jsonDateFormatCategorized, AnnotationTarget.SETTER, AnnotationTarget.PROPERTY, AnnotationTarget.CLASS);
            builder.setDeserializeDateFormatter(dateFormatter != null ? dateFormatter : configDateFormatter);
        }
    }

    private void introspectNumberFormatter(Property property, AnnotationIntrospector introspector, PropertyCustomizationBuilder builder) {
        Map<AnnotationTarget, JsonbNumberFormatter> jsonNumberFormatCategorized = introspector.getJsonNumberFormatter(property);
        if (!builder.isReadTransient()) {
            builder.setSerializeNumberFormatter(this.getTargetForMostPreciseScope(jsonNumberFormatCategorized, AnnotationTarget.GETTER, AnnotationTarget.PROPERTY, AnnotationTarget.CLASS));
        }
        if (!builder.isWriteTransient()) {
            builder.setDeserializeNumberFormatter(this.getTargetForMostPreciseScope(jsonNumberFormatCategorized, AnnotationTarget.SETTER, AnnotationTarget.PROPERTY, AnnotationTarget.CLASS));
        }
    }

    private <T> T getTargetForMostPreciseScope(Map<AnnotationTarget, T> collectedAnnotations, AnnotationTarget ... targets) {
        for (AnnotationTarget target : targets) {
            T result = collectedAnnotations.get((Object)target);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object getValue(Object object) {
        return this.propagation.getValue(object);
    }

    public void setValue(Object object, Object value) {
        if (!this.isWritable()) {
            return;
        }
        this.propagation.setValue(object, value);
    }

    public boolean isReadable() {
        return !this.customization.isReadTransient() && this.propagation.isReadable();
    }

    public boolean isWritable() {
        return !this.customization.isWriteTransient() && this.propagation.isWritable();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    public PropertyCustomization getCustomization() {
        return this.customization;
    }

    @Override
    public int compareTo(PropertyModel o) {
        int compare = this.readName.compareTo(o.readName);
        if (compare == 0) {
            compare = this.writeName.compareTo(o.writeName);
        }
        return compare;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyModel other = (PropertyModel)o;
        return Objects.equals(this.readName, other.readName) && Objects.equals(this.writeName, other.writeName);
    }

    public int hashCode() {
        return Objects.hash(this.readName, this.writeName);
    }

    public String getReadName() {
        return this.readName;
    }

    public String getWriteName() {
        return this.writeName;
    }

    public JsonbSerializer<?> getPropertySerializer() {
        return this.propertySerializer;
    }

    private String calculateReadWriteName(String readWriteName, PropertyNamingStrategy strategy) {
        return readWriteName != null ? readWriteName : strategy.translateName(this.propertyName);
    }

    public PropertyValuePropagation getPropagation() {
        return this.propagation;
    }
}

