/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ProcessingContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.model.JsonContext;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class OptionalObjectSerializer<T extends Optional<?>>
implements CurrentItem<T>,
JsonbSerializer<T> {
    private final JsonBindingModel wrapperModel;
    private final CurrentItem<?> wrapper;
    private final Type optionalValueType;

    public OptionalObjectSerializer(SerializerBuilder builder) {
        this.wrapper = builder.getWrapper();
        this.wrapperModel = builder.getModel();
        this.optionalValueType = this.resolveOptionalType(builder.getRuntimeType());
    }

    private Type resolveOptionalType(Type runtimeType) {
        if (runtimeType instanceof ParameterizedType) {
            return ((ParameterizedType)runtimeType).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    @Override
    public ClassModel getClassModel() {
        return null;
    }

    @Override
    public CurrentItem<?> getWrapper() {
        return this.wrapper;
    }

    @Override
    public Type getRuntimeType() {
        return this.optionalValueType;
    }

    @Override
    public JsonBindingModel getWrapperModel() {
        return this.wrapperModel;
    }

    public void serialize(T obj, JsonGenerator generator, SerializationContext ctx) {
        JsonbContext jsonbContext = ((ProcessingContext)ctx).getJsonbContext();
        if (obj == null || !((Optional)obj).isPresent()) {
            if (!this.wrapperModel.getCustomization().isNillable()) {
                return;
            }
            if (this.wrapperModel.getContext() == JsonContext.JSON_OBJECT) {
                generator.writeNull(this.wrapperModel.getWriteName());
            } else {
                generator.writeNull();
            }
            return;
        }
        Object optionalValue = ((Optional)obj).get();
        JsonbSerializer<?> serializer = ((SerializerBuilder)((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(jsonbContext).withObjectClass(optionalValue.getClass()).withType(this.optionalValueType)).withWrapper(this.wrapper)).withModel(this.wrapperModel)).build();
        this.serialCaptor(serializer, optionalValue, generator, ctx);
    }

    private <T> void serialCaptor(JsonbSerializer<?> serializer, T object, JsonGenerator generator, SerializationContext context) {
        serializer.serialize(object, generator, context);
    }
}

