/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.maven;

import com.google.common.base.Predicate;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtext.builder.standalone.LanguageAccessFactory;
import org.eclipse.xtext.builder.standalone.StandaloneBuilder;
import org.eclipse.xtext.builder.standalone.compiler.CompilerConfiguration;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.maven.ClusteringConfig;
import org.eclipse.xtext.maven.Language;
import org.eclipse.xtext.maven.MavenLog4JConfigurator;
import org.eclipse.xtext.maven.MavenStandaloneBuilderModule;
import org.eclipse.xtext.maven.ProjectMapping;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class AbstractXtextGeneratorMojo
extends AbstractMojo {
    private static final Object lock = new Object();
    @Parameter(defaultValue="${project.build.directory}/xtext-temp")
    private String tmpClassDirectory;
    @Parameter(property="xtext.encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.compileSourceRoots}", required=true)
    private List<String> sourceRoots;
    @Parameter(defaultValue="${project.compileSourceRoots}", required=true)
    private List<String> javaSourceRoots;
    @Parameter(required=true)
    private List<Language> languages;
    @Parameter
    private List<ProjectMapping> projectMappings;
    @Parameter(property="xtext.generator.skip", defaultValue="false")
    private Boolean skip;
    @Parameter(defaultValue="true")
    private Boolean failOnValidationError;
    @Parameter(property="maven.compiler.source", defaultValue="1.6")
    private String compilerSourceLevel;
    @Parameter(property="maven.compiler.target", defaultValue="1.6")
    private String compilerTargetLevel;
    @Parameter(defaultValue="false")
    private Boolean compilerSkipAnnotationProcessing;
    @Parameter(defaultValue="false")
    private Boolean compilerPreserveInformationAboutFormalParameters;
    @Parameter
    private String classPathLookupFilter;
    @Parameter
    private ClusteringConfig clusteringConfig;
    @Parameter(defaultValue="false")
    private Boolean autoFillPlatformResourceMap = Boolean.FALSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"skipped.");
        } else {
            Object object = lock;
            synchronized (object) {
                new MavenLog4JConfigurator().configureLog4j(this.getLog());
                this.autoAddToPlatformResourceMap(this.project);
                this.manuallyAddToPlatformResourceMap();
                this.internalExecute();
            }
        }
    }

    protected void internalExecute() throws MojoExecutionException, MojoFailureException {
        boolean errorDetected;
        Map languages = new LanguageAccessFactory().createLanguageAccess(this.getLanguages(), ((Object)((Object)this)).getClass().getClassLoader());
        Injector injector = Guice.createInjector((Module[])new Module[]{new MavenStandaloneBuilderModule()});
        StandaloneBuilder builder = (StandaloneBuilder)injector.getInstance(StandaloneBuilder.class);
        builder.setBaseDir(this.project.getBasedir().getAbsolutePath());
        builder.setLanguages(languages);
        builder.setEncoding(this.encoding);
        builder.setClassPathEntries(this.getClasspathElements());
        builder.setClassPathLookUpFilter(this.classPathLookupFilter);
        builder.setSourceDirs(this.sourceRoots);
        builder.setJavaSourceDirs(this.javaSourceRoots);
        builder.setFailOnValidationError(this.failOnValidationError.booleanValue());
        builder.setTempDir(this.createTempDir().getAbsolutePath());
        builder.setDebugLog(this.getLog().isDebugEnabled());
        if (this.clusteringConfig != null) {
            builder.setClusteringConfig(this.clusteringConfig.convertToStandaloneConfig());
        }
        this.configureCompiler(builder.getCompiler());
        this.logState();
        boolean bl = errorDetected = !builder.launch();
        if (errorDetected && this.failOnValidationError.booleanValue()) {
            throw new MojoExecutionException("Execution failed due to a severe validation error.");
        }
    }

    private void configureCompiler(IJavaCompiler compiler) {
        CompilerConfiguration conf = compiler.getConfiguration();
        conf.setSourceLevel(this.compilerSourceLevel);
        conf.setTargetLevel(this.compilerTargetLevel);
        conf.setVerbose(this.getLog().isDebugEnabled());
        conf.setSkipAnnotationProcessing(this.compilerSkipAnnotationProcessing.booleanValue());
        conf.setPreserveInformationAboutFormalParameters(this.compilerPreserveInformationAboutFormalParameters.booleanValue());
    }

    private void logState() {
        this.getLog().info((CharSequence)("Encoding: " + (this.encoding == null ? "not set. Encoding provider will be used." : this.encoding)));
        this.getLog().info((CharSequence)("Compiler source level: " + this.compilerSourceLevel));
        this.getLog().info((CharSequence)("Compiler target level: " + this.compilerTargetLevel));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Source dirs: " + IterableExtensions.join(this.sourceRoots, (CharSequence)", ")));
            this.getLog().debug((CharSequence)("Java source dirs: " + IterableExtensions.join(this.javaSourceRoots, (CharSequence)", ")));
            this.getLog().debug((CharSequence)("Classpath entries: " + IterableExtensions.join(this.getClasspathElements(), (CharSequence)", ")));
        }
    }

    private File createTempDir() {
        File tmpDir = new File(this.tmpClassDirectory);
        if (!tmpDir.mkdirs() && !tmpDir.exists()) {
            throw new IllegalArgumentException("Couldn't create directory '" + this.tmpClassDirectory + "'.");
        }
        return tmpDir;
    }

    protected Predicate<String> emptyStringFilter() {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isEmpty((String)input.trim());
            }
        };
    }

    public abstract Set<String> getClasspathElements();

    public List<Language> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<Language> languages) {
        this.languages = languages;
    }

    public List<ProjectMapping> getProjectMappings() {
        return this.projectMappings;
    }

    public void setProjectMappings(List<ProjectMapping> projectMappings) {
        this.projectMappings = projectMappings;
    }

    private void autoAddToPlatformResourceMap(MavenProject project) {
        if (this.autoFillPlatformResourceMap.booleanValue()) {
            this.addToPlatformResourceMap(project.getBasedir());
            project.getModules().stream().map(module -> new File(project.getBasedir(), (String)module)).forEach(e -> {
                URI uRI = this.addToPlatformResourceMap((File)e);
            });
            if (project.getParent() != null) {
                this.autoAddToPlatformResourceMap(project.getParent());
            }
        }
    }

    private void manuallyAddToPlatformResourceMap() {
        if (this.projectMappings != null) {
            for (ProjectMapping projectMapping : this.projectMappings) {
                if (projectMapping.getPath() == null || projectMapping.getProjectName() == null) continue;
                String path = projectMapping.getPath().toURI().toString();
                String name = projectMapping.getProjectName();
                this.getLog().info((CharSequence)("Adding project '" + name + "' with path '" + path + "' to Platform Resource Map"));
                URI uri = URI.createURI((String)path);
                EcorePlugin.getPlatformResourceMap().put(name, uri);
            }
        }
    }

    private URI addToPlatformResourceMap(File file) {
        this.getLog().info((CharSequence)("Adding project '" + file.getName() + "' with path '" + file.toURI().toString() + "' to Platform Resource Map"));
        URI uri = URI.createURI((String)file.toURI().toString());
        return EcorePlugin.getPlatformResourceMap().put(file.getName(), uri);
    }
}

