/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.xtext.builder.standalone.LanguageAccessFactory;
import org.eclipse.xtext.builder.standalone.StandaloneBuilder;
import org.eclipse.xtext.builder.standalone.compiler.CompilerConfiguration;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.maven.ClusteringConfig;
import org.eclipse.xtext.maven.Language;
import org.eclipse.xtext.maven.MavenLog4JConfigurator;
import org.eclipse.xtext.maven.MavenStandaloneBuilderModule;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XtextGenerator
extends AbstractMojo {
    private String tmpClassDirectory;
    protected String encoding;
    protected MavenProject project;
    private List<String> classpathElements;
    private List<String> sourceRoots;
    private List<String> javaSourceRoots;
    private List<Language> languages;
    private Boolean skip;
    private Boolean failOnValidationError;
    private String compilerSourceLevel;
    private String compilerTargetLevel;
    private String classPathLookupFilter;
    private ClusteringConfig clusteringConfig;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"skipped.");
        } else {
            new MavenLog4JConfigurator().configureLog4j(this.getLog());
            this.configureDefaults();
            this.internalExecute();
        }
    }

    protected void internalExecute() throws MojoExecutionException, MojoFailureException {
        boolean errorDetected;
        Map languages = new LanguageAccessFactory().createLanguageAccess(this.getLanguages(), ((Object)((Object)this)).getClass().getClassLoader());
        Injector injector = Guice.createInjector((Module[])new Module[]{new MavenStandaloneBuilderModule()});
        StandaloneBuilder builder = (StandaloneBuilder)injector.getInstance(StandaloneBuilder.class);
        builder.setBaseDir(this.project.getBasedir().getAbsolutePath());
        builder.setLanguages(languages);
        builder.setEncoding(this.encoding);
        builder.setClassPathEntries(this.getClasspathElements());
        builder.setClassPathLookUpFilter(this.classPathLookupFilter);
        builder.setSourceDirs(this.sourceRoots);
        builder.setJavaSourceDirs(this.javaSourceRoots);
        builder.setFailOnValidationError(this.failOnValidationError.booleanValue());
        builder.setTempDir(this.createTempDir().getAbsolutePath());
        builder.setDebugLog(this.getLog().isDebugEnabled());
        if (this.clusteringConfig != null) {
            builder.setClusteringConfig(this.clusteringConfig.convertToStandaloneConfig());
        }
        this.configureCompiler(builder.getCompiler());
        this.logState();
        boolean bl = errorDetected = !builder.launch();
        if (errorDetected && this.failOnValidationError.booleanValue()) {
            throw new MojoExecutionException("Execution failed due to a severe validation error.");
        }
    }

    private void configureCompiler(IJavaCompiler compiler) {
        CompilerConfiguration conf = compiler.getConfiguration();
        conf.setSourceLevel(this.compilerSourceLevel);
        conf.setTargetLevel(this.compilerTargetLevel);
        conf.setVerbose(this.getLog().isDebugEnabled());
    }

    private void logState() {
        this.getLog().info((CharSequence)("Encoding: " + (this.encoding == null ? "not set. Encoding provider will be used." : this.encoding)));
        this.getLog().info((CharSequence)("Compiler source level: " + this.compilerSourceLevel));
        this.getLog().info((CharSequence)("Compiler target level: " + this.compilerTargetLevel));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Source dirs: " + IterableExtensions.join(this.sourceRoots, (CharSequence)", ")));
            this.getLog().debug((CharSequence)("Java source dirs: " + IterableExtensions.join(this.javaSourceRoots, (CharSequence)", ")));
            this.getLog().debug((CharSequence)("Classpath entries: " + IterableExtensions.join(this.getClasspathElements(), (CharSequence)", ")));
        }
    }

    private File createTempDir() {
        File tmpDir = new File(this.tmpClassDirectory);
        if (!tmpDir.mkdirs() && !tmpDir.exists()) {
            throw new IllegalArgumentException("Couldn't create directory '" + this.tmpClassDirectory + "'.");
        }
        return tmpDir;
    }

    private Predicate<String> emptyStringFilter() {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isEmpty((String)input.trim());
            }
        };
    }

    public Set<String> getClasspathElements() {
        LinkedHashSet classpathElements = Sets.newLinkedHashSet();
        classpathElements.addAll(this.classpathElements);
        classpathElements.remove(this.project.getBuild().getOutputDirectory());
        classpathElements.remove(this.project.getBuild().getTestOutputDirectory());
        LinkedHashSet nonEmptyElements = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)classpathElements, this.emptyStringFilter()));
        return nonEmptyElements;
    }

    public List<Language> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<Language> languages) {
        this.languages = languages;
    }

    private void configureDefaults() {
        if (this.sourceRoots == null) {
            this.sourceRoots = Lists.newArrayList((Iterable)this.project.getCompileSourceRoots());
        }
        if (this.javaSourceRoots == null) {
            this.javaSourceRoots = Lists.newArrayList((Iterable)this.project.getCompileSourceRoots());
        }
    }
}

