/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.internal;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.eclipse.xtext.xbase.lib.internal.ar;
import org.eclipse.xtext.xbase.lib.internal.as;
import org.eclipse.xtext.xbase.lib.internal.d;
import org.eclipse.xtext.xbase.lib.internal.e;
import org.eclipse.xtext.xbase.lib.internal.f;
import org.eclipse.xtext.xbase.lib.internal.l;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class bd {
    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(E ... elements) {
        HashSet<E> set = bd.newHashSetWithExpectedSize(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(ar.capacity(expectedSize));
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> elements) {
        return elements instanceof Collection ? new HashSet<E>(l.cast(elements)) : bd.newHashSet(elements.iterator());
    }

    public static <E> HashSet<E> newHashSet(Iterator<? extends E> elements) {
        HashSet<E> set = bd.newHashSet();
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return set;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new LinkedHashSet<E>(l.cast(elements));
        }
        LinkedHashSet<E> set = bd.newLinkedHashSet();
        for (E element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <E> Set<E> filter(Set<E> unfiltered, e<? super E> predicate) {
        if (unfiltered instanceof SortedSet) {
            return bd.filter((SortedSet)unfiltered, predicate);
        }
        if (unfiltered instanceof a) {
            a filtered = (a)unfiltered;
            e<? super E> combinedPredicate = f.and(filtered.predicate, predicate);
            return new a<E>((Set)filtered.unfiltered, combinedPredicate);
        }
        return new a<E>(d.checkNotNull(unfiltered), d.checkNotNull(predicate));
    }

    public static <E> SortedSet<E> filter(SortedSet<E> unfiltered, e<? super E> predicate) {
        if (unfiltered instanceof a) {
            a filtered = (a)((Object)unfiltered);
            e<? super E> combinedPredicate = f.and(filtered.predicate, predicate);
            return new b<E>((SortedSet)filtered.unfiltered, combinedPredicate);
        }
        return new b<E>(d.checkNotNull(unfiltered), d.checkNotNull(predicate));
    }

    static int hashCodeImpl(Set<?> s2) {
        int hashCode = 0;
        for (Object o2 : s2) {
            hashCode += o2 != null ? o2.hashCode() : 0;
            hashCode = ~(~hashCode);
        }
        return hashCode;
    }

    static boolean equalsImpl(Set<?> s2, @Nullable Object object) {
        if (s2 == object) {
            return true;
        }
        if (object instanceof Set) {
            Set o2 = (Set)object;
            try {
                return s2.size() == o2.size() && s2.containsAll(o2);
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
        }
        return false;
    }

    static boolean removeAllImpl(Set<?> set, Iterator<?> iterator) {
        boolean changed = false;
        while (iterator.hasNext()) {
            changed |= set.remove(iterator.next());
        }
        return changed;
    }

    static boolean removeAllImpl(Set<?> set, Collection<?> collection) {
        d.checkNotNull(collection);
        if (collection instanceof as) {
            collection = ((as)collection).elementSet();
        }
        if (collection instanceof Set && collection.size() > set.size()) {
            Iterator<?> setIterator = set.iterator();
            boolean changed = false;
            while (setIterator.hasNext()) {
                if (!collection.contains(setIterator.next())) continue;
                changed = true;
                setIterator.remove();
            }
            return changed;
        }
        return bd.removeAllImpl(set, collection.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class b<E>
    extends a<E>
    implements SortedSet<E> {
        b(SortedSet<E> unfiltered, e<? super E> predicate) {
            super(unfiltered, predicate);
        }

        @Override
        public Comparator<? super E> comparator() {
            return ((SortedSet)this.unfiltered).comparator();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new b<E>(((SortedSet)this.unfiltered).subSet(fromElement, toElement), this.predicate);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new b<E>(((SortedSet)this.unfiltered).headSet(toElement), this.predicate);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new b<E>(((SortedSet)this.unfiltered).tailSet(fromElement), this.predicate);
        }

        @Override
        public E first() {
            return this.iterator().next();
        }

        @Override
        public E last() {
            SortedSet sortedUnfiltered = (SortedSet)this.unfiltered;
            Object element;
            while (!this.predicate.apply(element = sortedUnfiltered.last())) {
                sortedUnfiltered = sortedUnfiltered.headSet(element);
            }
            return element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class a<E>
    extends l.a<E>
    implements Set<E> {
        a(Set<E> unfiltered, e<? super E> predicate) {
            super(unfiltered, predicate);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return bd.equalsImpl(this, object);
        }

        @Override
        public int hashCode() {
            return bd.hashCodeImpl(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class c<E>
    extends AbstractSet<E> {
        c() {
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return bd.removeAllImpl(this, c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            return super.retainAll(d.checkNotNull(c2));
        }
    }
}

