/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.xtext.xbase.lib.internal.d;

public class ReflectExtensions {
    public void set(Object receiver, String fieldName, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        d.checkNotNull(receiver, "receiver");
        d.checkNotNull(fieldName, "fieldName");
        Class<?> clazz = receiver.getClass();
        Field f2 = this.getDeclaredField(clazz, fieldName);
        if (!f2.isAccessible()) {
            f2.setAccessible(true);
        }
        f2.set(receiver, value);
    }

    public <T> T get(Object receiver, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        d.checkNotNull(receiver, "receiver");
        d.checkNotNull(fieldName, "fieldName");
        Class<?> clazz = receiver.getClass();
        Field f2 = this.getDeclaredField(clazz, fieldName);
        if (!f2.isAccessible()) {
            f2.setAccessible(true);
        }
        return (T)f2.get(receiver);
    }

    private Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldException {
        NoSuchFieldException initialException = null;
        while (true) {
            try {
                Field f2 = clazz.getDeclaredField(name);
                return f2;
            }
            catch (NoSuchFieldException noSuchField) {
                if (initialException != null) continue;
                initialException = noSuchField;
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw initialException;
            }
            break;
        }
    }

    public Object invoke(Object receiver, String methodName, Object ... args) throws SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        d.checkNotNull(receiver, "receiver");
        d.checkNotNull(methodName, "methodName");
        Object[] arguments = args == null ? new Object[1] : args;
        Class<?> clazz = receiver.getClass();
        AccessibleObject compatible = null;
        do {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n2 = methodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Method candidate = methodArray[n3];
                if (candidate != null && !candidate.isBridge() && this.isCompatible(candidate, methodName, arguments)) {
                    if (compatible != null) {
                        throw new IllegalStateException("Ambiguous methods to invoke. Both " + compatible + " and  " + candidate + " would be compatible choices.");
                    }
                    compatible = candidate;
                }
                ++n3;
            }
        } while (compatible == null && (clazz = clazz.getSuperclass()) != null);
        if (compatible != null) {
            if (!compatible.isAccessible()) {
                ((Method)compatible).setAccessible(true);
            }
            return ((Method)compatible).invoke(receiver, arguments);
        }
        Class[] paramTypes = new Class[arguments.length];
        int i2 = 0;
        while (i2 < arguments.length) {
            paramTypes[i2] = arguments[i2] == null ? Object.class : arguments[i2].getClass();
            ++i2;
        }
        Method method = receiver.getClass().getMethod(methodName, paramTypes);
        return method.invoke(receiver, arguments);
    }

    private boolean isCompatible(Method candidate, String featureName, Object ... args) {
        if (!candidate.getName().equals(featureName)) {
            return false;
        }
        if (candidate.getParameterTypes().length != args.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < candidate.getParameterTypes().length) {
            Object param = args[i2];
            Class<?> class1 = candidate.getParameterTypes()[i2];
            if (class1.isPrimitive()) {
                class1 = this.wrapperTypeFor(class1);
            }
            if (param != null && !class1.isInstance(param)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private Class<?> wrapperTypeFor(Class<?> primitive) {
        d.checkNotNull(primitive);
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Void.TYPE) {
            return Void.class;
        }
        throw new IllegalArgumentException(primitive + " is not a primitive");
    }
}

