/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.internal;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import javax.annotation.Nullable;
import org.eclipse.xtext.xbase.lib.internal.ap;
import org.eclipse.xtext.xbase.lib.internal.bl;
import org.eclipse.xtext.xbase.lib.internal.bp;
import org.eclipse.xtext.xbase.lib.internal.l;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class aq {
    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(E ... elements) {
        org.eclipse.xtext.xbase.lib.internal.d.checkNotNull(elements);
        int capacity = aq.computeArrayListCapacity(elements.length);
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, elements);
        return list;
    }

    static int computeArrayListCapacity(int arraySize) {
        org.eclipse.xtext.xbase.lib.internal.d.checkArgument(arraySize >= 0);
        return bp.saturatedCast(5L + (long)arraySize + (long)(arraySize / 10));
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        org.eclipse.xtext.xbase.lib.internal.d.checkNotNull(elements);
        return elements instanceof Collection ? new ArrayList<E>(l.cast(elements)) : aq.newArrayList(elements.iterator());
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        org.eclipse.xtext.xbase.lib.internal.d.checkNotNull(elements);
        ArrayList<E> list = aq.newArrayList();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> elements) {
        LinkedList<E> list = aq.newLinkedList();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <F, T> List<T> transform(List<F> fromList, org.eclipse.xtext.xbase.lib.internal.a<? super F, ? extends T> function) {
        return fromList instanceof RandomAccess ? new c<F, T>(fromList, function) : new d<F, T>(fromList, function);
    }

    public static <T> List<T> reverse(List<T> list) {
        if (list instanceof b) {
            return ((b)list).getForwardList();
        }
        if (list instanceof RandomAccess) {
            return new a<T>(list);
        }
        return new b<T>(list);
    }

    static int hashCodeImpl(List<?> list) {
        int hashCode = 1;
        for (Object o2 : list) {
            hashCode = 31 * hashCode + (o2 == null ? 0 : o2.hashCode());
            hashCode = ~(~hashCode);
        }
        return hashCode;
    }

    static boolean equalsImpl(List<?> list, @Nullable Object object) {
        if (object == org.eclipse.xtext.xbase.lib.internal.d.checkNotNull(list)) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List o2 = (List)object;
        return list.size() == o2.size() && ap.elementsEqual(list.iterator(), o2.iterator());
    }

    static int indexOfImpl(List<?> list, @Nullable Object element) {
        ListIterator<?> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (!org.eclipse.xtext.xbase.lib.internal.c.equal(element, listIterator.next())) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    static int lastIndexOfImpl(List<?> list, @Nullable Object element) {
        ListIterator<?> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            if (!org.eclipse.xtext.xbase.lib.internal.c.equal(element, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class a<T>
    extends b<T>
    implements RandomAccess {
        a(List<T> forwardList) {
            super(forwardList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class b<T>
    extends AbstractList<T> {
        private final List<T> forwardList;

        b(List<T> forwardList) {
            this.forwardList = org.eclipse.xtext.xbase.lib.internal.d.checkNotNull(forwardList);
        }

        List<T> getForwardList() {
            return this.forwardList;
        }

        private int reverseIndex(int index) {
            int size = this.size();
            org.eclipse.xtext.xbase.lib.internal.d.checkElementIndex(index, size);
            return size - 1 - index;
        }

        private int reversePosition(int index) {
            int size = this.size();
            org.eclipse.xtext.xbase.lib.internal.d.checkPositionIndex(index, size);
            return size - index;
        }

        @Override
        public void add(int index, @Nullable T element) {
            this.forwardList.add(this.reversePosition(index), element);
        }

        @Override
        public void clear() {
            this.forwardList.clear();
        }

        @Override
        public T remove(int index) {
            return this.forwardList.remove(this.reverseIndex(index));
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.subList(fromIndex, toIndex).clear();
        }

        @Override
        public T set(int index, @Nullable T element) {
            return this.forwardList.set(this.reverseIndex(index), element);
        }

        @Override
        public T get(int index) {
            return this.forwardList.get(this.reverseIndex(index));
        }

        @Override
        public boolean isEmpty() {
            return this.forwardList.isEmpty();
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        public boolean contains(@Nullable Object o2) {
            return this.forwardList.contains(o2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.forwardList.containsAll(c2);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            org.eclipse.xtext.xbase.lib.internal.d.checkPositionIndexes(fromIndex, toIndex, this.size());
            return aq.reverse(this.forwardList.subList(this.reversePosition(toIndex), this.reversePosition(fromIndex)));
        }

        @Override
        public int indexOf(@Nullable Object o2) {
            int index = this.forwardList.lastIndexOf(o2);
            return index >= 0 ? this.reverseIndex(index) : -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object o2) {
            int index = this.forwardList.indexOf(o2);
            return index >= 0 ? this.reverseIndex(index) : -1;
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            int start = this.reversePosition(index);
            final ListIterator<T> forwardIterator = this.forwardList.listIterator(start);
            return new ListIterator<T>(){
                boolean canRemove;
                boolean canSet;

                @Override
                public void add(T e2) {
                    forwardIterator.add(e2);
                    forwardIterator.previous();
                    this.canRemove = false;
                    this.canSet = false;
                }

                @Override
                public boolean hasNext() {
                    return forwardIterator.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return forwardIterator.hasNext();
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemove = true;
                    this.canSet = true;
                    return forwardIterator.previous();
                }

                @Override
                public int nextIndex() {
                    return b.this.reversePosition(forwardIterator.nextIndex());
                }

                @Override
                public T previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemove = true;
                    this.canSet = true;
                    return forwardIterator.next();
                }

                @Override
                public int previousIndex() {
                    return this.nextIndex() - 1;
                }

                @Override
                public void remove() {
                    org.eclipse.xtext.xbase.lib.internal.d.checkState(this.canRemove);
                    forwardIterator.remove();
                    this.canSet = false;
                    this.canRemove = false;
                }

                @Override
                public void set(T e2) {
                    org.eclipse.xtext.xbase.lib.internal.d.checkState(this.canSet);
                    forwardIterator.set(e2);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class c<F, T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        final List<F> fromList;
        final org.eclipse.xtext.xbase.lib.internal.a<? super F, ? extends T> function;

        c(List<F> fromList, org.eclipse.xtext.xbase.lib.internal.a<? super F, ? extends T> function) {
            this.fromList = org.eclipse.xtext.xbase.lib.internal.d.checkNotNull(fromList);
            this.function = org.eclipse.xtext.xbase.lib.internal.d.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public T get(int index) {
            return this.function.apply(this.fromList.get(index));
        }

        @Override
        public boolean isEmpty() {
            return this.fromList.isEmpty();
        }

        @Override
        public T remove(int index) {
            return this.function.apply(this.fromList.remove(index));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class d<F, T>
    extends AbstractSequentialList<T>
    implements Serializable {
        final List<F> fromList;
        final org.eclipse.xtext.xbase.lib.internal.a<? super F, ? extends T> function;

        d(List<F> fromList, org.eclipse.xtext.xbase.lib.internal.a<? super F, ? extends T> function) {
            this.fromList = org.eclipse.xtext.xbase.lib.internal.d.checkNotNull(fromList);
            this.function = org.eclipse.xtext.xbase.lib.internal.d.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public int size() {
            return this.fromList.size();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return new bl<F, T>(this.fromList.listIterator(index)){

                @Override
                T transform(F from) {
                    return d.this.function.apply(from);
                }
            };
        }
    }
}

