/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.eclipse.xtext.xbase.lib.internal.a;
import org.eclipse.xtext.xbase.lib.internal.b;
import org.eclipse.xtext.xbase.lib.internal.bk;
import org.eclipse.xtext.xbase.lib.internal.bm;
import org.eclipse.xtext.xbase.lib.internal.bn;
import org.eclipse.xtext.xbase.lib.internal.c;
import org.eclipse.xtext.xbase.lib.internal.d;
import org.eclipse.xtext.xbase.lib.internal.e;
import org.eclipse.xtext.xbase.lib.internal.f;
import org.eclipse.xtext.xbase.lib.internal.h;
import org.eclipse.xtext.xbase.lib.internal.i;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ap {
    static final bn<Object> EMPTY_LIST_ITERATOR = new bn<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    };
    private static final Iterator<Object> EMPTY_MODIFIABLE_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    public static <T> bm<T> emptyIterator() {
        return ap.emptyListIterator();
    }

    static <T> bn<T> emptyListIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    public static <T> bm<T> unmodifiableIterator(final Iterator<T> iterator) {
        d.checkNotNull(iterator);
        if (iterator instanceof bm) {
            return (bm)iterator;
        }
        return new bm<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static int size(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static boolean contains(Iterator<?> iterator, @Nullable Object element) {
        if (element == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!element.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean removeAll(Iterator<?> removeFrom, Collection<?> elementsToRemove) {
        d.checkNotNull(elementsToRemove);
        boolean modified = false;
        while (removeFrom.hasNext()) {
            if (!elementsToRemove.contains(removeFrom.next())) continue;
            removeFrom.remove();
            modified = true;
        }
        return modified;
    }

    public static <T> boolean removeIf(Iterator<T> removeFrom, e<? super T> predicate) {
        d.checkNotNull(predicate);
        boolean modified = false;
        while (removeFrom.hasNext()) {
            if (!predicate.apply(removeFrom.next())) continue;
            removeFrom.remove();
            modified = true;
        }
        return modified;
    }

    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext()) {
            Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            if (c.equal(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator<?> iterator) {
        return b.on(", ").useForNull("null").appendTo(new StringBuilder().append('['), iterator).append(']').toString();
    }

    public static <T> T getOnlyElement(Iterator<T> iterator) {
        T first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("expected one element but was: <" + first);
        for (int i2 = 0; i2 < 4 && iterator.hasNext(); ++i2) {
            sb.append(", " + iterator.next());
        }
        if (iterator.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(sb.toString());
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        d.checkNotNull(addTo);
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return wasModified;
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> a2, Iterator<? extends T> b2) {
        d.checkNotNull(a2);
        d.checkNotNull(b2);
        return ap.concat(Arrays.asList(a2, b2).iterator());
    }

    public static <T> Iterator<T> concat(final Iterator<? extends Iterator<? extends T>> inputs) {
        d.checkNotNull(inputs);
        return new Iterator<T>(){
            Iterator<? extends T> current = ap.emptyIterator();
            Iterator<? extends T> removeFrom;

            @Override
            public boolean hasNext() {
                boolean currentHasNext;
                while (!(currentHasNext = d.checkNotNull(this.current).hasNext()) && inputs.hasNext()) {
                    this.current = (Iterator)inputs.next();
                }
                return currentHasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeFrom = this.current;
                return this.current.next();
            }

            @Override
            public void remove() {
                d.checkState(this.removeFrom != null, "no calls to next() since last call to remove()");
                this.removeFrom.remove();
                this.removeFrom = null;
            }
        };
    }

    public static <T> bm<T> filter(final Iterator<T> unfiltered, final e<? super T> predicate) {
        d.checkNotNull(unfiltered);
        d.checkNotNull(predicate);
        return new i<T>(){

            @Override
            protected T computeNext() {
                while (unfiltered.hasNext()) {
                    Object element = unfiltered.next();
                    if (!predicate.apply(element)) continue;
                    return element;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> bm<T> filter(Iterator<?> unfiltered, Class<T> type) {
        return ap.filter(unfiltered, f.instanceOf(type));
    }

    public static <T> boolean any(Iterator<T> iterator, e<? super T> predicate) {
        d.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (!predicate.apply(element)) continue;
            return true;
        }
        return false;
    }

    public static <F, T> Iterator<T> transform(Iterator<F> fromIterator, final a<? super F, ? extends T> function) {
        d.checkNotNull(function);
        return new bk<F, T>(fromIterator){

            @Override
            T transform(F from) {
                return function.apply(from);
            }
        };
    }

    static <T> bn<T> forArray(final T[] array, final int offset, int length, int index) {
        d.checkArgument(length >= 0);
        int end = offset + length;
        d.checkPositionIndexes(offset, end, array.length);
        return new h<T>(length, index){

            @Override
            protected T get(int index) {
                return array[offset + index];
            }
        };
    }

    public static <T> bm<T> singletonIterator(final @Nullable T value) {
        return new bm<T>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return value;
            }
        };
    }

    static <T> ListIterator<T> cast(Iterator<T> iterator) {
        return (ListIterator)iterator;
    }
}

