/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.internal.ad;
import org.eclipse.xtext.xbase.lib.internal.ae;
import org.eclipse.xtext.xbase.lib.internal.ai;
import org.eclipse.xtext.xbase.lib.internal.aq;
import org.eclipse.xtext.xbase.lib.internal.ar;
import org.eclipse.xtext.xbase.lib.internal.bd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionLiterals {
    @Pure
    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    @Pure
    public static <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    @Pure
    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    @Pure
    public static <T> List<T> newImmutableList(T ... elements) {
        return ad.copyOf(elements);
    }

    @Pure
    public static <T> Set<T> newImmutableSet(T ... elements) {
        return ai.copyOf(elements);
    }

    @Pure
    public static <K, V> Map<K, V> newImmutableMap(Pair<? extends K, ? extends V> ... entries) {
        if (entries.length == 0) {
            return CollectionLiterals.emptyMap();
        }
        ae.a<K, V> builder = ae.builder();
        Pair<? extends K, ? extends V>[] pairArray = entries;
        int n2 = entries.length;
        int n3 = 0;
        while (n3 < n2) {
            Pair<K, V> entry = pairArray[n3];
            builder.put(entry.getKey(), entry.getValue());
            ++n3;
        }
        return builder.build();
    }

    @Pure
    public static <T> ArrayList<T> newArrayList(T ... initial) {
        return aq.newArrayList(initial);
    }

    @Pure
    public static <T> LinkedList<T> newLinkedList(T ... initial) {
        if (initial.length > 0) {
            return aq.newLinkedList(Arrays.asList(initial));
        }
        return aq.newLinkedList();
    }

    @Pure
    public static <T> HashSet<T> newHashSet(T ... initial) {
        return bd.newHashSet(initial);
    }

    @Pure
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... initial) {
        if (initial.length > 0) {
            return bd.newLinkedHashSet(Arrays.asList(initial));
        }
        return bd.newLinkedHashSet();
    }

    @Pure
    public static <T> TreeSet<T> newTreeSet(Comparator<? super T> comparator, T ... initial) {
        TreeSet<T> result = new TreeSet<T>(comparator);
        if (initial.length > 0) {
            result.addAll(Arrays.asList(initial));
        }
        return result;
    }

    @Pure
    public static <K, V> HashMap<K, V> newHashMap(Pair<? extends K, ? extends V> ... initial) {
        HashMap result = ar.newHashMapWithExpectedSize(initial.length);
        CollectionLiterals.putAll(result, initial);
        return result;
    }

    @Pure
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Pair<? extends K, ? extends V> ... initial) {
        LinkedHashMap result = new LinkedHashMap(initial.length);
        CollectionLiterals.putAll(result, initial);
        return result;
    }

    @Pure
    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator, Pair<? extends K, ? extends V> ... initial) {
        TreeMap result = ar.newTreeMap(comparator);
        CollectionLiterals.putAll(result, initial);
        return result;
    }

    private static <K, V> void putAll(Map<K, V> result, Pair<? extends K, ? extends V> ... entries) {
        Pair<? extends K, ? extends V>[] pairArray = entries;
        int n2 = entries.length;
        int n3 = 0;
        while (n3 < n2) {
            Pair<K, V> entry = pairArray[n3];
            if (result.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("duplicate key: " + entry.getKey());
            }
            result.put(entry.getKey(), entry.getValue());
            ++n3;
        }
    }
}

