/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.xtext.web.server.XtextServiceDispatcher;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class XtextResourcesServlet
extends HttpServlet {
    private static final long DEFAULT_EXPIRE_TIME_MS = 86400000L;
    private static final long DEFAULT_EXPIRE_TIME_S = 86400L;
    private boolean disableCache = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String disableCache = config.getInitParameter("disableCache");
        if (disableCache != null) {
            boolean _parseBoolean;
            this.disableCache = _parseBoolean = Boolean.parseBoolean(disableCache);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String _servletPath = request.getServletPath();
            String _plus = "META-INF/resources" + _servletPath;
            String _pathInfo = request.getPathInfo();
            String resourceURI = _plus + _pathInfo;
            InputStream inputStream = this.getResourceAsStream(resourceURI);
            if (inputStream != null) {
                int _length_1;
                boolean _greaterThan;
                String[] tokens = resourceURI.split("/");
                int _length = tokens.length;
                int _minus = _length - 1;
                String fileName = tokens[_minus];
                boolean _and = false;
                _and = this.disableCache ? false : (_greaterThan = (_length_1 = tokens.length) > 4);
                if (_and) {
                    String version = tokens[3];
                    response.setHeader("ETag", fileName + "_" + version);
                    long _currentTimeMillis = System.currentTimeMillis();
                    long _plus_1 = _currentTimeMillis + 86400000L;
                    response.setDateHeader("Expires", _plus_1);
                    response.addHeader("Cache-Control", "private, max-age=" + Long.valueOf(86400L));
                }
                ServletContext _servletContext = this.getServletContext();
                String mimeType = _servletContext.getMimeType(fileName);
                String _elvis = null;
                _elvis = mimeType != null ? mimeType : "application/octet-stream";
                response.setContentType(_elvis);
                ServletOutputStream _outputStream = response.getOutputStream();
                ByteStreams.copy((InputStream)inputStream, (OutputStream)_outputStream);
            } else {
                response.sendError(404);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected InputStream getResourceAsStream(String resourceURI) {
        ClassLoader _classLoader = XtextServiceDispatcher.class.getClassLoader();
        return _classLoader.getResourceAsStream(resourceURI);
    }
}

