/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.web.server.IRequestData;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.ISessionStore;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.XtextServiceDispatcher;
import org.eclipse.xtext.web.server.generator.GeneratorResult;
import org.eclipse.xtext.web.servlet.HttpServletRequestData;
import org.eclipse.xtext.web.servlet.HttpServletSessionStore;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class XtextServlet
extends HttpServlet {
    private final Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass());
    private final IResourceServiceProvider.Registry serviceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
    private final Gson gson = new Gson();

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            super.service(req, resp);
        }
        catch (Throwable _t) {
            if (_t instanceof InvalidRequestException.ResourceNotFoundException) {
                InvalidRequestException.ResourceNotFoundException exception = (InvalidRequestException.ResourceNotFoundException)_t;
                String _requestURI = req.getRequestURI();
                String _plus = "Invalid request (" + _requestURI;
                String _plus_1 = _plus + "): ";
                String _message = exception.getMessage();
                String _plus_2 = _plus_1 + _message;
                this.LOG.trace((Object)_plus_2);
                String _message_1 = exception.getMessage();
                resp.sendError(404, _message_1);
            }
            if (_t instanceof InvalidRequestException.InvalidDocumentStateException) {
                InvalidRequestException.InvalidDocumentStateException exception_1 = (InvalidRequestException.InvalidDocumentStateException)_t;
                String _requestURI_1 = req.getRequestURI();
                String _plus_3 = "Invalid request (" + _requestURI_1;
                String _plus_4 = _plus_3 + "): ";
                String _message_2 = exception_1.getMessage();
                String _plus_5 = _plus_4 + _message_2;
                this.LOG.trace((Object)_plus_5);
                String _message_3 = exception_1.getMessage();
                resp.sendError(409, _message_3);
            }
            if (_t instanceof InvalidRequestException.PermissionDeniedException) {
                InvalidRequestException.PermissionDeniedException exception_2 = (InvalidRequestException.PermissionDeniedException)_t;
                String _requestURI_2 = req.getRequestURI();
                String _plus_6 = "Invalid request (" + _requestURI_2;
                String _plus_7 = _plus_6 + "): ";
                String _message_4 = exception_2.getMessage();
                String _plus_8 = _plus_7 + _message_4;
                this.LOG.trace((Object)_plus_8);
                String _message_5 = exception_2.getMessage();
                resp.sendError(403, _message_5);
            }
            if (_t instanceof InvalidRequestException) {
                InvalidRequestException exception_3 = (InvalidRequestException)_t;
                String _requestURI_3 = req.getRequestURI();
                String _plus_9 = "Invalid request (" + _requestURI_3;
                String _plus_10 = _plus_9 + "): ";
                String _message_6 = exception_3.getMessage();
                String _plus_11 = _plus_10 + _message_6;
                this.LOG.trace((Object)_plus_11);
                String _message_7 = exception_3.getMessage();
                resp.sendError(400, _message_7);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean _not;
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        boolean _and = false;
        boolean _isHasConflict = service.isHasConflict();
        boolean bl = _not = !_isHasConflict;
        if (!_not) {
            _and = false;
        } else {
            boolean _isHasTextInput;
            boolean _or = false;
            boolean _isHasSideEffects = service.isHasSideEffects();
            _or = _isHasSideEffects ? true : (_isHasTextInput = service.isHasTextInput());
            _and = _or;
        }
        if (_and) {
            super.doGet(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String _type;
        boolean _notEquals;
        boolean _not;
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        boolean _and = false;
        boolean _isHasConflict = service.isHasConflict();
        boolean bl = _not = !_isHasConflict;
        _and = !_not ? false : (_notEquals = !Objects.equal((Object)(_type = service.getType()), (Object)"update"));
        if (_and) {
            super.doPut(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean _not;
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        boolean _and = false;
        boolean _isHasConflict = service.isHasConflict();
        boolean bl = _not = !_isHasConflict;
        if (!_not) {
            _and = false;
        } else {
            boolean _isHasTextInput;
            boolean _not_2;
            boolean _not_1;
            boolean _or = false;
            boolean _and_1 = false;
            boolean _isHasSideEffects = service.isHasSideEffects();
            boolean bl2 = _not_1 = !_isHasSideEffects;
            _and_1 = !_not_1 ? false : (_not_2 = !(_isHasTextInput = service.isHasTextInput()));
            if (_and_1) {
                _or = true;
            } else {
                boolean _equals;
                String _type = service.getType();
                _or = _equals = Objects.equal((Object)_type, (Object)"update");
            }
            _and = _or;
        }
        if (_and) {
            super.doPost(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected XtextServiceDispatcher.ServiceDescriptor getService(HttpServletRequest request) throws InvalidRequestException {
        HttpSession _session = request.getSession();
        HttpServletSessionStore sessionStore = new HttpServletSessionStore(_session);
        HttpServletRequestData requestData = new HttpServletRequestData(request);
        Injector injector = this.getInjector(requestData);
        XtextServiceDispatcher serviceDispatcher = (XtextServiceDispatcher)injector.getInstance(XtextServiceDispatcher.class);
        XtextServiceDispatcher.ServiceDescriptor service = serviceDispatcher.getService((IRequestData)requestData, (ISessionStore)sessionStore);
        this.checkPermission(request, service);
        return service;
    }

    protected void doService(XtextServiceDispatcher.ServiceDescriptor service, HttpServletResponse response) {
        try {
            Functions.Function0 _service = service.getService();
            IServiceResult result = (IServiceResult)_service.apply();
            if (result instanceof GeneratorResult) {
                String _contentType;
                boolean _isNullOrEmpty;
                boolean _not;
                List _documents = ((GeneratorResult)result).getDocuments();
                GeneratorResult.GeneratedDocument document = (GeneratorResult.GeneratedDocument)IterableExtensions.head((Iterable)_documents);
                boolean _and = false;
                _and = document == null ? false : (_not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)(_contentType = document.getContentType()))));
                if (_and) {
                    response.setStatus(200);
                    String _contentType_1 = document.getContentType();
                    response.setContentType(_contentType_1);
                    response.setHeader("Cache-Control", "no-cache");
                    PrintWriter _writer = response.getWriter();
                    String _content = document.getContent();
                    _writer.write(_content);
                    return;
                }
            }
            response.setStatus(200);
            response.setContentType("text/x-json;charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            PrintWriter _writer_1 = response.getWriter();
            this.gson.toJson((Object)result, (Appendable)_writer_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void checkPermission(HttpServletRequest request, XtextServiceDispatcher.ServiceDescriptor service) throws InvalidRequestException.PermissionDeniedException {
    }

    protected Injector getInjector(IRequestData requestData) throws InvalidRequestException.UnknownLanguageException {
        IResourceServiceProvider _resourceServiceProvider_1;
        IResourceServiceProvider _resourceServiceProvider;
        IResourceServiceProvider resourceServiceProvider = null;
        String _elvis = null;
        String _parameter = requestData.getParameter("resource");
        _elvis = _parameter != null ? _parameter : "";
        URI emfURI = URI.createURI((String)_elvis);
        String contentType = requestData.getParameter("contentType");
        resourceServiceProvider = contentType == null ? (_resourceServiceProvider = this.serviceProviderRegistry.getResourceServiceProvider(emfURI)) : (_resourceServiceProvider_1 = this.serviceProviderRegistry.getResourceServiceProvider(emfURI, contentType));
        boolean _equals = Objects.equal((Object)resourceServiceProvider, null);
        if (_equals) {
            throw new InvalidRequestException.UnknownLanguageException("Unable to identify the Xtext language.");
        }
        return (Injector)resourceServiceProvider.get(Injector.class);
    }
}

