/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.validation;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplate;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplates;
import org.eclipse.xtext.ui.codetemplates.templates.TemplateBody;
import org.eclipse.xtext.ui.codetemplates.templates.TemplatePart;
import org.eclipse.xtext.ui.codetemplates.templates.TemplatesPackage;
import org.eclipse.xtext.ui.codetemplates.templates.Variable;
import org.eclipse.xtext.ui.codetemplates.ui.registry.LanguageRegistry;
import org.eclipse.xtext.ui.codetemplates.ui.resolvers.IInspectableTemplateVariableResolver;
import org.eclipse.xtext.ui.codetemplates.ui.resolvers.InspectableTemplateVariableResolverRegistry;
import org.eclipse.xtext.ui.codetemplates.validation.CodetemplatesJavaValidator;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class TemplateValidator
extends CodetemplatesJavaValidator {
    @Inject
    private InspectableTemplateVariableResolverRegistry registry;
    @Inject
    private LanguageRegistry languageRegistry;

    @Check
    public void checkTemplate(TemplateBody template) {
        EList parts = template.getParts();
        boolean cursorDefined = false;
        for (TemplatePart templatePart : parts) {
            if (!(templatePart instanceof Variable) || !"cursor".equals(((Variable)templatePart).getName())) continue;
            if (cursorDefined) {
                this.warning("More than one cursor was defined", (EObject)templatePart, (EStructuralFeature)TemplatesPackage.Literals.VARIABLE__NAME);
                continue;
            }
            cursorDefined = true;
        }
    }

    @Check
    public void checkParameterSyntax(Variable variable) {
        TemplateTranslator templateTranslator = new TemplateTranslator();
        String text = NodeModelUtils.getNode((EObject)variable).getText();
        try {
            templateTranslator.translate(text);
        }
        catch (TemplateException templateException) {
            this.error(templateTranslator.getErrorMessage(), (EObject)variable, (EStructuralFeature)TemplatesPackage.Literals.VARIABLE__NAME);
        }
    }

    @Check
    public void checkParameters(Variable variable) {
        Codetemplate template = (Codetemplate)EcoreUtil2.getContainerOfType((EObject)variable, Codetemplate.class);
        Codetemplates templates = (Codetemplates)EcoreUtil2.getContainerOfType((EObject)template, Codetemplates.class);
        if (templates != null && template != null) {
            Grammar language = templates.getLanguage();
            AbstractRule rule = template.getContext();
            ContextTypeIdHelper helper = this.languageRegistry.getContextTypeIdHelper(language);
            if (helper != null && rule != null && !rule.eIsProxy() && rule instanceof ParserRule) {
                String contextTypeId = helper.getId(rule);
                ContextTypeRegistry contextTypeRegistry = this.languageRegistry.getContextTypeRegistry(language);
                TemplateContextType contextType = contextTypeRegistry.getContextType(contextTypeId);
                if (contextType != null) {
                    UnmodifiableIterator resolvers = Iterators.filter((Iterator)contextType.resolvers(), TemplateVariableResolver.class);
                    String type = variable.getType();
                    if (type == null) {
                        type = variable.getName();
                    }
                    while (resolvers.hasNext()) {
                        IInspectableTemplateVariableResolver inspectableResolver;
                        TemplateVariableResolver resolver = (TemplateVariableResolver)resolvers.next();
                        if (!resolver.getType().equals(type) || (inspectableResolver = this.registry.toInspectableResolver(resolver)) == null) continue;
                        inspectableResolver.validateParameters(variable, (ValidationMessageAcceptor)this);
                    }
                }
            }
        }
    }

    @Check
    public void checkNameIsNotEmpty(Codetemplate template) {
        if (Strings.isEmpty((String)template.getName())) {
            this.error("Template name cannot be empty.", (EStructuralFeature)TemplatesPackage.Literals.CODETEMPLATE__NAME);
        }
    }
}

