/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.extensions;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.inject.Injector;
import java.util.Optional;
import org.eclipse.xtext.testing.IInjectorProvider;
import org.eclipse.xtext.testing.IRegistryConfigurator;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.util.Exceptions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class InjectionExtension
implements BeforeEachCallback,
AfterEachCallback,
TestInstancePostProcessor {
    private static ClassToInstanceMap<IInjectorProvider> injectorProviderClassCache = MutableClassToInstanceMap.create();

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        IInjectorProvider injectorProvider = InjectionExtension.getOrCreateInjectorProvider(context);
        if (injectorProvider != null) {
            this.setupRegistry(injectorProvider, context);
            Injector injector = injectorProvider.getInjector();
            if (injector != null) {
                injector.injectMembers(testInstance);
            }
        }
    }

    protected void setupRegistry(IInjectorProvider injectorProvider, ExtensionContext context) {
        if (injectorProvider instanceof IRegistryConfigurator) {
            IRegistryConfigurator registryConfigurator = (IRegistryConfigurator)((Object)injectorProvider);
            ((RegistryReset)context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this})).getOrComputeIfAbsent((Object)registryConfigurator, RegistryReset::new, RegistryReset.class)).setup();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        IInjectorProvider injectorProvider = InjectionExtension.getOrCreateInjectorProvider(context);
        if (injectorProvider instanceof IRegistryConfigurator) {
            this.setupRegistry(injectorProvider, context);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        IInjectorProvider injectorProvider = InjectionExtension.getOrCreateInjectorProvider(context);
        this.restoreRegistry(injectorProvider, context);
    }

    protected void restoreRegistry(IInjectorProvider injectorProvider, ExtensionContext context) {
        if (injectorProvider instanceof IRegistryConfigurator) {
            IRegistryConfigurator registryConfigurator = (IRegistryConfigurator)((Object)injectorProvider);
            RegistryReset resetter = (RegistryReset)context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this})).get((Object)registryConfigurator, RegistryReset.class);
            if (resetter != null) {
                try {
                    resetter.close();
                }
                catch (Throwable e) {
                    throw new ExtensionConfigurationException("Failed to restore registry", e);
                }
            }
        }
    }

    protected static IInjectorProvider getOrCreateInjectorProvider(ExtensionContext context) {
        InjectWith injectWith = context.getRequiredTestClass().getAnnotation(InjectWith.class);
        if (injectWith != null) {
            Class<? extends IInjectorProvider> klass = injectWith.value();
            IInjectorProvider injectorProvider = (IInjectorProvider)injectorProviderClassCache.get(klass);
            if (injectorProvider == null) {
                try {
                    injectorProvider = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    injectorProviderClassCache.put(klass, (Object)injectorProvider);
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedException((Throwable)e);
                }
            }
            return injectorProvider;
        }
        Optional<ExtensionContext> parentContext = context.getParent().filter(p -> p.getTestClass().isPresent());
        if (parentContext.isPresent()) {
            return InjectionExtension.getOrCreateInjectorProvider(parentContext.get());
        }
        return null;
    }

    protected static class RegistryReset
    implements ExtensionContext.Store.CloseableResource {
        protected final IRegistryConfigurator resetter;
        protected boolean didSetup = false;

        public RegistryReset(IRegistryConfigurator resetter) {
            this.resetter = resetter;
            resetter.setupRegistry();
        }

        public void setup() {
            if (!this.didSetup) {
                this.didSetup = true;
                this.resetter.setupRegistry();
            }
        }

        public void close() throws Throwable {
            if (this.didSetup) {
                this.resetter.restoreRegistry();
                this.didSetup = false;
            }
        }
    }
}

