/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.extensions;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.inject.Injector;
import java.lang.reflect.Modifier;
import org.eclipse.xtext.testing.IInjectorProvider;
import org.eclipse.xtext.testing.IRegistryConfigurator;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.util.Exceptions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;

public class InjectionExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static ClassToInstanceMap<IInjectorProvider> injectorProviderClassCache = MutableClassToInstanceMap.create();

    public void beforeEach(ExtensionContext context) throws Exception {
        block5: {
            Injector injector;
            IInjectorProvider injectorProvider = InjectionExtension.getOrCreateInjectorProvider(context);
            if (injectorProvider instanceof IRegistryConfigurator) {
                IRegistryConfigurator registryConfigurator = (IRegistryConfigurator)((Object)injectorProvider);
                registryConfigurator.setupRegistry();
            }
            if (injectorProvider != null && (injector = injectorProvider.getInjector()) != null) {
                Object testInstance = context.getRequiredTestInstance();
                injector.injectMembers(testInstance);
                try {
                    TestInstances requiredTestInstances = context.getRequiredTestInstances();
                    for (Object o : requiredTestInstances.getEnclosingInstances()) {
                        injector.injectMembers(o);
                    }
                }
                catch (NoSuchMethodError e) {
                    if (Modifier.isStatic(testInstance.getClass().getModifiers()) || testInstance.getClass().getDeclaringClass() == null) break block5;
                    throw new ExtensionConfigurationException("Injection of nested classes needs Junit5 >= 5.4", (Throwable)e);
                }
            }
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        IInjectorProvider injectorProvider = InjectionExtension.getOrCreateInjectorProvider(context);
        if (injectorProvider instanceof IRegistryConfigurator) {
            IRegistryConfigurator registryConfigurator = (IRegistryConfigurator)((Object)injectorProvider);
            registryConfigurator.restoreRegistry();
        }
    }

    private static InjectWith getInjectWith(Class<?> cls) {
        InjectWith result = null;
        Class<?> firstClassMatched = null;
        while (cls != null) {
            InjectWith iw = cls.getAnnotation(InjectWith.class);
            if (iw != null) {
                if (result != null) {
                    throw new ExtensionConfigurationException(String.format("Multiple @InjectWith annotations are found (%s and %s). Only a single one is supported.", firstClassMatched.getName(), cls.getName()));
                }
                result = iw;
                firstClassMatched = cls;
            }
            cls = cls.getEnclosingClass();
        }
        return result;
    }

    private static IInjectorProvider getOrCreateInjectorProvider(ExtensionContext context) {
        InjectWith injectWith = InjectionExtension.getInjectWith(context.getRequiredTestClass());
        if (injectWith != null) {
            Class<? extends IInjectorProvider> klass = injectWith.value();
            IInjectorProvider injectorProvider = (IInjectorProvider)injectorProviderClassCache.get(klass);
            if (injectorProvider == null) {
                try {
                    injectorProvider = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    injectorProviderClassCache.put(klass, (Object)injectorProvider);
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedException((Throwable)e);
                }
            }
            return injectorProvider;
        }
        return null;
    }
}

