/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJavaSchemeUriResolver;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractClassMirror;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.java.resource.JavaDerivedStateComputer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class JavaResource
extends ResourceImpl
implements IJavaSchemeUriResolver,
ISynchronizable<JavaResource> {
    public static final String OPTION_ENCODING = JavaResource.class.getName() + ".DEFAULT_ENCODING";
    @Inject
    private IEncodingProvider encodingProvider;
    @Inject
    private JavaDerivedStateComputer derivedStateComputer;
    private CompilationUnit compilationUnit;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private boolean initialized = false;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private boolean initializing = false;
    private IndexedJvmTypeAccess _access;
    private final IFragmentProvider.Fallback fallback = new IFragmentProvider.Fallback(){

        public EObject getEObject(String fragment) {
            return JavaResource.super.getEObjectByID(fragment);
        }

        public String getFragment(EObject obj) {
            return JavaResource.super.getURIFragment(obj);
        }
    };
    private final AbstractClassMirror m = new AbstractClassMirror(){

        protected String getTypeName() {
            throw new UnsupportedOperationException("TODO: auto-generated method stub");
        }

        protected String getTypeName(JvmType type) {
            return type.getIdentifier();
        }

        public void initialize(TypeResource typeResource) {
            throw new UnsupportedOperationException("TODO: auto-generated method stub");
        }

        public boolean isSealed() {
            throw new UnsupportedOperationException("TODO: auto-generated method stub");
        }
    };

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        CompilationUnit _compilationUnit;
        URI _uRI = this.getURI();
        String encoding = this.getEncoding(_uRI, options);
        InputStreamReader _inputStreamReader = new InputStreamReader(inputStream, encoding);
        String contentsAsString = CharStreams.toString((Readable)_inputStreamReader);
        char[] _charArray = contentsAsString.toCharArray();
        URI _uRI_1 = this.getURI();
        String _lastSegment = _uRI_1.lastSegment();
        this.compilationUnit = _compilationUnit = new CompilationUnit(_charArray, _lastSegment, encoding);
    }

    protected String getEncoding(URI uri, Map<?, ?> options) {
        Object encodingOption;
        if (options != null && (encodingOption = options.get(OPTION_ENCODING)) instanceof String) {
            return (String)encodingOption;
        }
        return this.encodingProvider.getEncoding(uri);
    }

    protected CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList<EObject> getContents() {
        EList _xsynchronizedexpression = null;
        Object object = this.getLock();
        synchronized (object) {
            EList _xblockexpression = null;
            if (this.isLoaded && !this.isLoading && !this.initializing && !this.initialized) {
                try {
                    this.eSetDeliver(false);
                    this.installFull();
                }
                finally {
                    this.eSetDeliver(true);
                }
            }
            _xsynchronizedexpression = _xblockexpression = super.getContents();
        }
        return _xsynchronizedexpression;
    }

    public void installStubs() {
        Procedures.Procedure0 _function = () -> {
            this.derivedStateComputer.installStubs((Resource)this);
            this.initialized = true;
        };
        this.initializing(_function);
    }

    public void installFull() {
        Procedures.Procedure0 _function = () -> {
            this.derivedStateComputer.installFull((Resource)this);
            this.initialized = true;
        };
        this.initializing(_function);
    }

    private void initializing(Procedures.Procedure0 init) {
        try {
            this.initializing = true;
            init.apply();
        }
        finally {
            this.initializing = false;
        }
    }

    public void discardDerivedState() {
        Procedures.Procedure0 _function = () -> {
            this.derivedStateComputer.discardDerivedState((Resource)this);
            this.initialized = false;
        };
        this.initializing(_function);
    }

    public EObject resolveJavaObjectURIProxy(InternalEObject proxy, JvmTypeReference sender) {
        IndexedJvmTypeAccess access = this.getIndexJvmTypeAccess();
        if (access != null) {
            try {
                URI _eProxyURI = proxy.eProxyURI();
                ResourceSet _resourceSet = this.getResourceSet();
                EObject result = access.getIndexedJvmType(_eProxyURI, _resourceSet);
                if (result != null) {
                    return result;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof IndexedJvmTypeAccess.UnknownNestedTypeException) {
                    IndexedJvmTypeAccess.UnknownNestedTypeException e = (IndexedJvmTypeAccess.UnknownNestedTypeException)_t;
                    return proxy;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return EcoreUtil.resolve((EObject)proxy, (EObject)sender);
    }

    public IndexedJvmTypeAccess getIndexJvmTypeAccess() {
        Resource.Factory.Registry _resourceFactoryRegistry;
        Map _protocolToFactoryMap;
        Object provider;
        if (this._access == null && (provider = (_protocolToFactoryMap = (_resourceFactoryRegistry = this.resourceSet.getResourceFactoryRegistry()).getProtocolToFactoryMap()).get("java")) instanceof AbstractJvmTypeProvider) {
            IndexedJvmTypeAccess _indexedJvmTypeAccess;
            this._access = _indexedJvmTypeAccess = ((AbstractJvmTypeProvider)provider).getIndexedJvmTypeAccess();
        }
        return this._access;
    }

    public Object getLock() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet instanceof ISynchronizable) {
            return ((ISynchronizable)resourceSet).getLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Result> Result execute(IUnitOfWork<Result, ? super JavaResource> unit) throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            return (Result)unit.exec((Object)this);
        }
    }

    protected EObject getEObjectByID(String id) {
        return this.m.getEObject((Resource)this, id, this.fallback);
    }

    public String getURIFragment(EObject eObject) {
        return this.m.getFragment(eObject, this.fallback);
    }

    @Pure
    public boolean isInitialized() {
        return this.initialized;
    }

    @Pure
    public boolean isInitializing() {
        return this.initializing;
    }

    public static class Factory
    implements Resource.Factory {
        @Inject
        private Provider<JavaResource> resourceProvider;

        public Resource createResource(URI uri) {
            JavaResource _get = (JavaResource)((Object)this.resourceProvider.get());
            Procedures.Procedure1 _function = it -> it.setURI(uri);
            return (Resource)ObjectExtensions.operator_doubleArrow((Object)((Object)_get), (Procedures.Procedure1)_function);
        }
    }
}

