/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.trace.StorageAwareTrace;
import org.eclipse.xtext.builder.trace.TraceMarkers;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfig;
import org.eclipse.xtext.ui.workspace.EclipseWorkspaceConfigProvider;
import org.eclipse.xtext.workspace.IProjectConfig;

public class TraceForStorageProvider
implements ITraceForStorageProvider {
    @Deprecated
    public static final String TRACE_FILE_EXTENSION = "._trace";
    private static final Logger log = Logger.getLogger(TraceForStorageProvider.class);
    @Inject
    private Provider<StorageAwareTrace> traceToSourceProvider;
    @Inject
    private TraceMarkers traceMarkers;
    @Inject
    private IWorkspace workspace;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private TraceFileNameProvider traceFileNameProvider;
    @Inject
    private IResourceServiceProvider.Registry serviceRegistry;
    @Inject
    private CachedTraces cachedTraces;

    public ITrace getTraceToSource(final IStorage derivedResource) {
        StorageAwareTrace result = (StorageAwareTrace)this.traceToSourceProvider.get();
        result.setLocalStorage(derivedResource);
        result.setTraceRegionProvider(new ITraceRegionProvider(){

            public AbstractTraceRegion getTraceRegion() {
                IStorage traceFile;
                IStorage resource = derivedResource;
                if (resource instanceof IFile && (traceFile = TraceForStorageProvider.this.getTraceFile(resource)) instanceof IFile) {
                    return TraceForStorageProvider.this.cachedTraces.getTraceRegion((IFile)traceFile);
                }
                throw new TraceNotFoundException();
            }
        });
        return result;
    }

    public ITrace getTraceToTarget(IStorage sourceResource) {
        if (sourceResource instanceof IFile) {
            try {
                IFile sourceFile = (IFile)sourceResource;
                final List<IPath> traceFiles = this.traceMarkers.findTraceFiles(sourceFile);
                if (!traceFiles.isEmpty()) {
                    StorageAwareTrace result = (StorageAwareTrace)this.traceToSourceProvider.get();
                    result.setLocalStorage(sourceResource);
                    final URI sourceFileURI = this.storage2UriMapper.getUri(sourceResource);
                    IProject containingProject = sourceFile.getProject();
                    IResourceServiceProvider serviceProvider = this.serviceRegistry.getResourceServiceProvider(sourceFileURI);
                    EclipseWorkspaceConfigProvider configProvider = (EclipseWorkspaceConfigProvider)serviceProvider.get(EclipseWorkspaceConfigProvider.class);
                    final EclipseProjectConfig projectConfig = configProvider == null ? null : configProvider.getProjectConfig(containingProject);
                    final ITraceURIConverter traceURIConverter = (ITraceURIConverter)serviceProvider.get(ITraceURIConverter.class);
                    result.setTraceRegionProvider(new ITraceRegionProvider(){

                        public AbstractTraceRegion getTraceRegion() {
                            ArrayList result = Lists.newArrayList();
                            for (IPath tracePath : traceFiles) {
                                IFile traceFile = TraceForStorageProvider.this.workspace.getRoot().getFile(tracePath);
                                if (!traceFile.exists()) continue;
                                IStorage generatedFileForTraceFile = TraceForStorageProvider.this.getGeneratedFileForTraceFile((IStorage)traceFile);
                                if (generatedFileForTraceFile == null) {
                                    throw new TraceNotFoundException();
                                }
                                AbstractTraceRegion traceRegion = TraceForStorageProvider.this.cachedTraces.getTraceRegion(traceFile);
                                IPath generatedFilePath = generatedFileForTraceFile.getFullPath();
                                URI generatedFileURI = URI.createPlatformResourceURI((String)generatedFilePath.toString(), (boolean)true);
                                if (projectConfig == null) continue;
                                URI sourceUriForTrace = traceURIConverter.getURIForTrace((IProjectConfig)projectConfig, sourceFileURI);
                                URI generatedUriForTrace = traceURIConverter.getURIForTrace((IProjectConfig)projectConfig, generatedFileURI);
                                if (sourceUriForTrace == null || generatedUriForTrace == null) continue;
                                result.addAll(traceRegion.invertFor(sourceUriForTrace, generatedUriForTrace));
                            }
                            if (result.isEmpty()) {
                                throw new TraceNotFoundException();
                            }
                            return AbstractTraceRegion.mergedFrom((List)result);
                        }
                    });
                    return result;
                }
            }
            catch (CoreException coreException) {
                log.info((Object)coreException.getMessage(), (Throwable)coreException);
            }
        }
        return null;
    }

    public IStorage getTraceFile(IStorage storage) {
        if (storage instanceof IFile) {
            IFile file = (IFile)storage;
            String originLastSegment = file.getFullPath().lastSegment();
            IFile traceFile = file.getParent().getFile((IPath)new Path(this.traceFileNameProvider.getTraceFromJava(originLastSegment)));
            return traceFile;
        }
        return null;
    }

    public boolean isTraceFile(IStorage storage) {
        if (!(storage instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)storage;
        String originLastSegment = file.getFullPath().lastSegment();
        return this.traceFileNameProvider.isTraceFileName(originLastSegment);
    }

    protected IStorage getGeneratedFileForTraceFile(IStorage traceFile) {
        if (traceFile instanceof IFile) {
            IFile file = (IFile)traceFile;
            String lastSegment = traceFile.getFullPath().lastSegment();
            lastSegment = this.traceFileNameProvider.getJavaFromTrace(lastSegment);
            return file.getParent().getFile((IPath)new Path(lastSegment));
        }
        return null;
    }

    @Singleton
    protected static class CachedTraces {
        @Inject
        private TraceRegionSerializer traceRegionSerializer;
        private Map<PathWithTimestamp, AbstractTraceRegion> cache = new LinkedHashMap<PathWithTimestamp, AbstractTraceRegion>(32, 0.75f, true){
            private static final long serialVersionUID = 1L;
            final int MAX_SIZE = 20;
            {
                this.MAX_SIZE = 20;
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<PathWithTimestamp, AbstractTraceRegion> eldest) {
                return this.size() > 20;
            }
        };

        protected CachedTraces() {
        }

        /*
         * Loose catch block
         */
        protected synchronized AbstractTraceRegion getTraceRegion(IFile file) throws TraceNotFoundException {
            if (file.exists()) {
                PathWithTimestamp key = new PathWithTimestamp(file);
                AbstractTraceRegion result = this.cache.get(key);
                if (result != null) {
                    return result;
                }
                InputStream contents = null;
                contents = file.getContents();
                result = this.traceRegionSerializer.readTraceRegionFrom(contents);
                this.cache.put(key, result);
                AbstractTraceRegion abstractTraceRegion = result;
                try {
                    Closeables.close((Closeable)contents, (boolean)true);
                }
                catch (IOException iOException) {}
                return abstractTraceRegion;
                catch (Exception e) {
                    try {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            Closeables.close((Closeable)contents, (boolean)true);
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        Closeables.close((Closeable)contents, (boolean)true);
                    }
                    catch (IOException iOException) {}
                }
            }
            throw new TraceNotFoundException();
        }

        private static class PathWithTimestamp {
            private final IPath path;
            private final long timestamp;

            public PathWithTimestamp(IFile file) {
                this.path = file.getFullPath();
                this.timestamp = file.getModificationStamp();
            }

            public int hashCode() {
                int result = 1;
                result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
                result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PathWithTimestamp other = (PathWithTimestamp)obj;
                if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
                    return false;
                }
                return this.timestamp == other.timestamp;
            }
        }
    }
}

