/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.xtext.builder.standalone.incremental.BinaryFileHashing;

@Singleton
public class ClasspathInfos {
    private static final Logger logger = Logger.getLogger(ClasspathInfos.class);
    private static final int _16_KB = 16384;
    private ConcurrentHashMap<IPath, HashCode> hashes = new ConcurrentHashMap();

    public byte[] hashClassesOrJar(IPath path) {
        return this.hashes.computeIfAbsent(path, any -> {
            if ("jar".equalsIgnoreCase(path.getFileExtension())) {
                String maybeHash;
                List<String> segments = Arrays.asList(path.segments());
                if (segments.contains(".gradle") && (maybeHash = segments.get(segments.size() - 2)).length() >= 36) {
                    return BinaryFileHashing.hashFunction().hashString((CharSequence)maybeHash, StandardCharsets.ISO_8859_1);
                }
                File mavenSha1 = path.addFileExtension("sha1").toFile();
                if (mavenSha1.isFile()) {
                    try {
                        byte[] bytes = Files.readAllBytes(mavenSha1.toPath());
                        return BinaryFileHashing.hashFunction().hashBytes(bytes);
                    }
                    catch (IOException e) {
                        logger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            Hasher hasher = BinaryFileHashing.hashFunction().newHasher();
            try (OutputStream hasherAsStream = Funnels.asOutputStream((PrimitiveSink)hasher);){
                com.google.common.io.Files.fileTraverser().breadthFirst((Object)path.toFile()).forEach(file -> {
                    String fileName;
                    if (file.isFile() && ((fileName = file.getName().toLowerCase()).endsWith(".class") || fileName.endsWith(".jar"))) {
                        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream((File)file), 16384);){
                            ByteStreams.copy((InputStream)in, (OutputStream)hasherAsStream);
                        }
                        catch (IOException e) {
                            hasher.putBoolean(false);
                        }
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return hasher.hash();
        }).asBytes();
    }
}

