/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.compiler;

import com.google.common.base.Stopwatch;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.xtext.builder.standalone.compiler.AccessibleReferenceCollection;
import org.eclipse.xtext.builder.standalone.compiler.ClassFileResourceDescription;
import org.eclipse.xtext.builder.standalone.compiler.EclipseJavaCompiler;
import org.eclipse.xtext.builder.standalone.compiler.SerializedCompilerState;
import org.eclipse.xtext.builder.standalone.incremental.BinaryFileHashing;
import org.eclipse.xtext.builder.standalone.incremental.ClasspathInfos;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.CoarseGrainedChangeEvent;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;

class InternalIncrementalCompiler
extends Main {
    private static final Logger LOG = Logger.getLogger(EclipseJavaCompiler.class);
    private final File stateDirectory;
    private final Map<IPath, CompilationUnit> remainingCompilationUnits;
    private final IResourceDescription.Event.Listener eventListener;
    private final ClasspathInfos classpathInfos;
    private boolean fullBuild = false;
    private CompilationUnit[] toCompile;
    private SerializedCompilerState serializedCompileResult;
    private HashCode classpathHash;
    private Set<String> qualifiedNames;
    private Set<String> simpleNames;
    private Set<String> rootNames;
    private Stopwatch rootStopwatch;

    InternalIncrementalCompiler(Writer outputWriter, Writer errorWriter, File stateDirectory, IResourceDescription.Event.Listener eventListener, ClasspathInfos classpathInfos) {
        super(new PrintWriter(outputWriter), new PrintWriter(errorWriter), false, null, null);
        this.stateDirectory = stateDirectory;
        this.eventListener = eventListener;
        this.classpathInfos = classpathInfos;
        this.remainingCompilationUnits = new HashMap<IPath, CompilationUnit>();
        this.qualifiedNames = new HashSet<String>(3);
        this.simpleNames = new HashSet<String>(3);
        this.rootNames = new HashSet<String>(3);
    }

    public CompilationUnit[] getCompilationUnits() {
        this.compilerOptions.produceReferenceInfo = true;
        if (this.toCompile == null) {
            CompilationUnit[] allCompilationUnits = super.getCompilationUnits();
            if (this.stateDirectory == null) {
                this.fullBuild = true;
                return allCompilationUnits;
            }
            this.toCompile = this.diff(allCompilationUnits);
        }
        return this.toCompile;
    }

    protected ArrayList<FileSystem.Classpath> handleClasspath(ArrayList<String> classpaths, String customEncoding) {
        Stopwatch sw = Stopwatch.createStarted();
        ArrayList result = super.handleClasspath(classpaths, customEncoding);
        Path destinationPath = new Path(this.destinationPath);
        boolean found = false;
        ArrayList<Future> hashCodes = new ArrayList<Future>();
        for (Object cp : result) {
            Path path = new Path(cp.getPath());
            if (destinationPath.equals((Object)path)) {
                found = true;
                continue;
            }
            hashCodes.add(ForkJoinPool.commonPool().submit(() -> this.lambda$handleClasspath$0((IPath)path)));
        }
        Hasher hasher = this.newHasher();
        for (ForkJoinTask forkJoinTask : hashCodes) {
            try {
                hasher.putBytes((byte[])forkJoinTask.get(30L, TimeUnit.SECONDS));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                hasher.putBoolean(false);
            }
        }
        this.classpathHash = hasher.hash();
        LOG.trace((Object)("Processed first stage classpath in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms."));
        if (found) {
            return result;
        }
        File destinationFile = destinationPath.toFile();
        try {
            Files.createDirectories(destinationFile.toPath(), new FileAttribute[0]);
            FileSystem.Classpath classpath = FileSystem.getClasspath((String)destinationFile.getAbsolutePath(), (String)customEncoding, null, (Map)this.options, (String)this.releaseVersion);
            result.add(0, classpath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private CompilationUnit[] scheduleAffected() {
        ArrayList<CompilationUnit> result = new ArrayList<CompilationUnit>();
        this.scheduleAffected(result);
        return result.toArray(new CompilationUnit[0]);
    }

    private void scheduleAffected(List<CompilationUnit> result) {
        char[][] internedSimpleNames;
        if (this.qualifiedNames.size() == 0 && this.simpleNames.size() == 0) {
            return;
        }
        char[][][] internedQualifiedNames = ReferenceCollection.internQualifiedNames(this.qualifiedNames);
        if (internedQualifiedNames.length < this.qualifiedNames.size()) {
            internedQualifiedNames = null;
        }
        if ((internedSimpleNames = ReferenceCollection.internSimpleNames(this.simpleNames, (boolean)true)).length < this.simpleNames.size()) {
            internedSimpleNames = null;
        }
        char[][] internedRootNames = ReferenceCollection.internSimpleNames(this.rootNames, (boolean)false);
        for (IPath filename : this.serializedCompileResult.inputFiles.keySet()) {
            AccessibleReferenceCollection refs;
            if (!this.remainingCompilationUnits.containsKey(filename) || !(refs = this.serializedCompileResult.referenceInformation.get(filename)).includes(internedQualifiedNames, internedSimpleNames, internedRootNames)) continue;
            this.schedule(filename, result, null, true);
        }
    }

    private void addDependentsOf(IPath path) {
        path = path.setDevice(null);
        this.rootNames.add(path.segment(0));
        String packageName = path.removeLastSegments(1).toString();
        this.qualifiedNames.add(packageName);
        String typeName = path.lastSegment();
        int memberIndex = typeName.indexOf(36);
        if (memberIndex > 0) {
            typeName = typeName.substring(0, memberIndex);
        }
        this.simpleNames.add(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilationUnit[] diff(CompilationUnit[] allCompilationUnits) {
        HashCode hashedClassPath = this.processClasspaths();
        Map<IPath, HashCode> inputFiles = this.processInputFiles(allCompilationUnits);
        try {
            if (hashedClassPath.equals((Object)this.serializedCompileResult.hashedClasspath)) {
                LOG.info((Object)"ClassPath is equal to previous round. Attempt to reuse up-to-date compile results.");
                ArrayList<CompilationUnit> result = new ArrayList<CompilationUnit>();
                ArrayList changedTypes = new ArrayList();
                this.serializedCompileResult.inputFiles.forEach((filename, prevHashCode) -> {
                    HashCode hashCode = (HashCode)inputFiles.get(filename);
                    if (!prevHashCode.equals((Object)hashCode)) {
                        this.schedule((IPath)filename, (List<CompilationUnit>)result, changedTypes, true);
                    }
                });
                inputFiles.forEach((filename, hashCode) -> {
                    if (!this.serializedCompileResult.inputFiles.containsKey(filename)) {
                        this.schedule((IPath)filename, (List<CompilationUnit>)result, changedTypes, false);
                    }
                });
                Map<IPath, HashCode> outputDirectoryContent = this.processOutputDirectories();
                outputDirectoryContent.forEach((outputFile, currentHashCode) -> {
                    HashCode hashCode = this.serializedCompileResult.outputFiles.get(outputFile);
                    if (!currentHashCode.equals((Object)hashCode)) {
                        IPath filename = this.serializedCompileResult.outputToInputFile.remove(outputFile);
                        this.schedule(filename, result, changedTypes, true);
                    }
                });
                this.serializedCompileResult.outputFiles.entrySet().removeIf(entry -> {
                    IPath expectedOutputFile = (IPath)entry.getKey();
                    if (!outputDirectoryContent.containsKey(expectedOutputFile)) {
                        IPath filename = this.serializedCompileResult.outputToInputFile.remove(expectedOutputFile);
                        this.schedule(filename, result, changedTypes, false);
                        return true;
                    }
                    return false;
                });
                this.serializedCompileResult.inputFiles.forEach((filename, prevHashCode) -> {
                    IPath[] outputFiles;
                    HashCode hashCode = (HashCode)inputFiles.get(filename);
                    if (prevHashCode.equals((Object)hashCode) && (outputFiles = this.serializedCompileResult.inputToOutputFiles.get(filename)) != null && !outputDirectoryContent.keySet().containsAll(Arrays.asList(outputFiles))) {
                        this.schedule((IPath)filename, (List<CompilationUnit>)result, changedTypes, true);
                    }
                });
                for (String typeName : changedTypes) {
                    this.addDependentsOf((IPath)new Path(typeName));
                }
                this.scheduleAffected(result);
                this.logCount(result.size(), "Everything up-to-date.");
                CompilationUnit[] compilationUnitArray = result.toArray(new CompilationUnit[0]);
                return compilationUnitArray;
            }
            LOG.info((Object)"No valid previous result detected. Compile all source files.");
            this.deleteClassFiles();
            this.remainingCompilationUnits.clear();
            this.serializedCompileResult.outputFiles.clear();
            this.serializedCompileResult.inputToOutputFiles.clear();
            this.serializedCompileResult.outputToInputFile.clear();
            this.serializedCompileResult.referenceInformation.clear();
            this.serializedCompileResult.outputToTypeName.clear();
            this.logCount(allCompilationUnits.length, "No sources found.");
            CompilationUnit[] compilationUnitArray = allCompilationUnits;
            return compilationUnitArray;
        }
        finally {
            this.serializedCompileResult.inputFiles.clear();
            this.serializedCompileResult.inputFiles.putAll(inputFiles);
            this.serializedCompileResult.hashedClasspath = hashedClassPath;
        }
    }

    private void logCount(int count, String zeroMessage) {
        switch (count) {
            case 0: {
                LOG.info((Object)zeroMessage);
                break;
            }
            case 1: {
                LOG.info((Object)"Found 1 source file to compile.");
                break;
            }
            default: {
                LOG.info((Object)("Found " + count + " source files to compile."));
            }
        }
    }

    private void schedule(IPath filename, List<CompilationUnit> compilationUnits, List<String> changedTypes, boolean removeFromOutputFiles) {
        CompilationUnit compilationUnit = this.remainingCompilationUnits.remove(filename);
        if (compilationUnit != null) {
            LOG.debug((Object)("Add to build queue: " + filename));
            compilationUnits.add(compilationUnit);
        }
        this.serializedCompileResult.referenceInformation.remove(filename);
        IPath[] outputFiles = this.serializedCompileResult.inputToOutputFiles.remove(filename);
        if (outputFiles != null) {
            for (IPath prevClassFile : outputFiles) {
                File file;
                String typeName = this.serializedCompileResult.outputToTypeName.remove(prevClassFile);
                if (typeName != null && changedTypes != null) {
                    changedTypes.add(typeName);
                }
                this.serializedCompileResult.outputToInputFile.remove(prevClassFile);
                if (removeFromOutputFiles) {
                    this.serializedCompileResult.outputFiles.remove(prevClassFile);
                }
                if (!(file = prevClassFile.toFile()).exists()) continue;
                LOG.debug((Object)("Delete outdated class file: " + prevClassFile));
                file.delete();
            }
        }
    }

    private void deleteClassFiles() {
        HashSet<String> seen = new HashSet<String>();
        seen.add(this.destinationPath);
        this.deleteClassFiles(this.destinationPath);
        for (String path : this.destinationPaths) {
            if (path == null || !seen.add(path)) continue;
            this.deleteClassFiles(path);
        }
    }

    private void deleteClassFiles(String filename) {
        com.google.common.io.Files.fileTraverser().breadthFirst((Object)new File(filename)).forEach(file -> {
            if (file.isFile() && file.getName().endsWith(".class")) {
                LOG.debug((Object)("Delete outdated class file: " + file.getAbsolutePath()));
                file.delete();
            }
        });
    }

    private HashCode processClasspaths() {
        Stopwatch sw = Stopwatch.createStarted();
        FileSystem.Classpath[] classpaths = this.checkedClasspaths;
        Hasher hasher = this.newHasher();
        hasher.putBytes(this.classpathHash.asBytes());
        Path destinationPath = new Path(this.destinationPath);
        for (FileSystem.Classpath cp : classpaths) {
            File file;
            Path path = new Path(cp.getPath());
            if (destinationPath.equals((Object)path) || !(file = path.toFile()).isFile()) continue;
            hasher.putLong(file.length());
        }
        HashCode result = hasher.hash();
        LOG.trace((Object)("Processed second stage classpath in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms. Hash: " + result.toString()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<IPath, HashCode> processInputFiles(CompilationUnit[] allCompilationUnits) {
        LOG.trace((Object)"Scannning sources");
        Stopwatch sw = Stopwatch.createStarted();
        HashMap<IPath, HashCode> result = new HashMap<IPath, HashCode>();
        for (CompilationUnit compilationUnit : allCompilationUnits) {
            Path filename = new Path(String.valueOf(compilationUnit.getFileName()));
            char[] contents = compilationUnit.getContents();
            try {
                HashCode hash = BinaryFileHashing.hashFunction().hashUnencodedChars((CharSequence)CharBuffer.wrap(contents));
                result.put((IPath)filename, hash);
                LOG.trace((Object)("Hashed source file " + filename.lastSegment() + " to " + hash));
            }
            catch (Exception e) {
                result.put((IPath)filename, BinaryFileHashing.unknownHashCode());
            }
            finally {
                this.remainingCompilationUnits.put((IPath)filename, compilationUnit);
            }
        }
        LOG.trace((Object)("Scanned sources in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        return result;
    }

    private Map<IPath, HashCode> processOutputDirectories() {
        LOG.trace((Object)"Scannning class directories");
        Stopwatch sw = Stopwatch.createStarted();
        HashMap<IPath, HashCode> result = new HashMap<IPath, HashCode>();
        HashSet<String> seen = new HashSet<String>();
        seen.add(this.destinationPath);
        InternalIncrementalCompiler.processOutputDirectory(this.destinationPath, result);
        for (String path : this.destinationPaths) {
            if (path == null || !seen.add(path)) continue;
            InternalIncrementalCompiler.processOutputDirectory(path, result);
        }
        LOG.trace((Object)("Scanned class " + (seen.size() == 1 ? "directory" : "directories") + " in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        return result;
    }

    private static void processOutputDirectory(String directory, Map<IPath, HashCode> result) {
        LOG.debug((Object)("Scanning class directory " + directory));
        BinaryFileHashing.processDirectory(directory, result, ".class");
    }

    public void outputClassFiles(CompilationResult unitResult) {
        if (this.serializedCompileResult != null) {
            this.hashCompiledClassFiles(unitResult);
        }
        super.outputClassFiles(unitResult);
    }

    private void hashCompiledClassFiles(CompilationResult unitResult) {
        ClassFile[] classFiles = unitResult.getClassFiles();
        if (classFiles != null) {
            Path inputFilename = new Path(String.valueOf(unitResult.getFileName()));
            AccessibleReferenceCollection referenceCollection = new AccessibleReferenceCollection(unitResult.qualifiedReferences, unitResult.simpleNameReferences, unitResult.rootReferences);
            this.serializedCompileResult.referenceInformation.put((IPath)inputFilename, referenceCollection);
            String currentDestinationPath = null;
            CompilationUnit compilationUnit = (CompilationUnit)unitResult.compilationUnit;
            if (compilationUnit.destinationPath == null) {
                if (this.destinationPath == null) {
                    currentDestinationPath = this.extractDestinationPathFromSourceFile(unitResult);
                } else if (this.destinationPath != "none") {
                    currentDestinationPath = this.destinationPath;
                }
            } else if (compilationUnit.destinationPath != "none") {
                currentDestinationPath = compilationUnit.destinationPath;
            }
            if (currentDestinationPath != null) {
                ArrayList<IPath> paths = new ArrayList<IPath>(classFiles.length);
                for (ClassFile classFile : classFiles) {
                    char[] filename = classFile.fileName();
                    if (filename != null) {
                        String filenameString = new String(filename);
                        this.addDependentsOf((IPath)new Path(filenameString));
                        int length = filename.length;
                        char[] relativeName = new char[length + 6];
                        System.arraycopy(filename, 0, relativeName, 0, length);
                        System.arraycopy(SuffixConstants.SUFFIX_class, 0, relativeName, length, 6);
                        CharOperation.replace((char[])relativeName, (char)'/', (char)File.separatorChar);
                        String relativeStringName = new String(relativeName);
                        Hasher hasher = this.newHasher();
                        hasher.putBytes(classFile.header, 0, classFile.headerOffset);
                        hasher.putBytes(classFile.contents, 0, classFile.contentsOffset);
                        IPath outputFilename = new Path(currentDestinationPath).append(relativeStringName);
                        HashCode hash = hasher.hash();
                        this.serializedCompileResult.outputFiles.put(outputFilename, hash);
                        LOG.trace((Object)("Hashed compiled class file " + outputFilename.lastSegment() + " to " + hash));
                        paths.add(outputFilename);
                        this.serializedCompileResult.outputToTypeName.put(outputFilename, filenameString);
                        this.serializedCompileResult.outputToInputFile.put(outputFilename, (IPath)inputFilename);
                        continue;
                    }
                    LOG.trace((Object)"EEEK");
                }
                this.serializedCompileResult.inputToOutputFiles.put((IPath)inputFilename, paths.toArray(new IPath[0]));
            }
        }
    }

    private Hasher newHasher() {
        return BinaryFileHashing.hashFunction().newHasher();
    }

    public void performCompilation() {
        Stopwatch sw;
        if (this.stateDirectory == null) {
            super.performCompilation();
            this.eventListener.descriptionsChanged((IResourceDescription.Event)new CoarseGrainedChangeEvent());
            return;
        }
        File stateFile = new File(this.stateDirectory, "java.state");
        this.serializedCompileResult = SerializedCompilerState.from(stateFile);
        Map<URI, ClassFileResourceDescription> originalIndex = this.eventListener != null ? this.serializedCompileResult.resourceDescriptions() : null;
        int round = 1;
        do {
            this.qualifiedNames = new HashSet<String>(3);
            this.simpleNames = new HashSet<String>(3);
            this.rootNames = new HashSet<String>(3);
            sw = Stopwatch.createStarted();
            super.performCompilation();
            LOG.trace((Object)("Compilation round " + round + " took " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms"));
            sw.reset();
            sw.start();
            this.toCompile = this.scheduleAffected();
            LOG.trace((Object)("Finding affected source files took " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms"));
            sw.stop();
            ++round;
        } while (this.toCompile.length > 0);
        if (this.eventListener != null) {
            if (this.fullBuild) {
                this.eventListener.descriptionsChanged((IResourceDescription.Event)new CoarseGrainedChangeEvent());
            } else {
                sw = Stopwatch.createStarted();
                Map<URI, ClassFileResourceDescription> newIndex = this.serializedCompileResult.resourceDescriptions();
                MapDifference difference = Maps.difference(originalIndex, newIndex);
                ArrayList<DefaultResourceDescriptionDelta> deltas = new ArrayList<DefaultResourceDescriptionDelta>();
                for (ClassFileResourceDescription removed : difference.entriesOnlyOnLeft().values()) {
                    deltas.add(new DefaultResourceDescriptionDelta((IResourceDescription)removed, null));
                }
                for (ClassFileResourceDescription added : difference.entriesOnlyOnRight().values()) {
                    deltas.add(new DefaultResourceDescriptionDelta(null, (IResourceDescription)added));
                }
                for (MapDifference.ValueDifference diff : difference.entriesDiffering().values()) {
                    deltas.add(new DefaultResourceDescriptionDelta((IResourceDescription)diff.leftValue(), (IResourceDescription)diff.rightValue()));
                }
                LOG.trace((Object)("Compared Xtext index for Java files in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms"));
                this.eventListener.descriptionsChanged((IResourceDescription.Event)new ResourceDescriptionChangeEvent(deltas));
            }
        }
        this.serializedCompileResult.to(stateFile, this.rootStopwatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile(String[] argv) {
        this.rootStopwatch = Stopwatch.createStarted();
        try {
            boolean bl = super.compile(argv);
            return bl;
        }
        finally {
            long duration = this.rootStopwatch.elapsed(TimeUnit.MILLISECONDS);
            LOG.info((Object)("Compilation took " + duration + "ms."));
            LOG.info((Object)("Detected up-to-date source files: " + this.remainingCompilationUnits.size()));
            if (duration != this.serializedCompileResult.duration) {
                LOG.info((Object)("Estimated time saved: " + Math.max(0L, this.serializedCompileResult.duration - duration) + "ms."));
            }
        }
    }

    private /* synthetic */ byte[] lambda$handleClasspath$0(IPath path) throws Exception {
        return this.classpathInfos.hashClassesOrJar(path);
    }
}

