/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.standalone.ClusteringConfig;
import org.eclipse.xtext.builder.standalone.IIssueHandler;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class StandaloneBuilder {
    private static final Logger LOG = Logger.getLogger(StandaloneBuilder.class);
    @Accessors
    private Map<String, LanguageAccess> languages;
    @Accessors
    private String baseDir;
    @Accessors
    private Iterable<String> sourceDirs;
    @Accessors
    private Iterable<String> javaSourceDirs = CollectionLiterals.newArrayList();
    @Accessors
    private Iterable<String> classPathEntries;
    @Accessors
    private File tempDir = Files.createTempDir();
    @Accessors
    private String encoding;
    @Accessors
    private String classPathLookUpFilter;
    @Accessors
    private boolean failOnValidationError = true;
    @Accessors
    private boolean debugLog;
    @Accessors
    private boolean writeStorageResources;
    @Accessors
    private ClusteringConfig clusteringConfig = null;
    @Inject
    private IndexedJvmTypeAccess jvmTypeAccess;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private AbstractFileSystemAccess commonFileAccess;
    @Inject
    protected IIssueHandler issueHandler;
    @Inject
    private IEncodingProvider.Runtime encodingProvider;
    @Inject
    private IJavaCompiler compiler;
    private Map<LanguageAccess, JavaIoFileSystemAccess> configuredFsas = CollectionLiterals.newHashMap();

    public void setTempDir(String pathAsString) {
        if (pathAsString != null) {
            File _file;
            this.tempDir = _file = new File(pathAsString);
        }
    }

    public boolean launch() {
        Functions.Function1 _function = it -> it.isLinksAgainstJava();
        boolean needsJava = IterableExtensions.exists(this.languages.values(), (Functions.Function1)_function);
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("user.dir");
            LOG.warn((Object)("Property baseDir not set. Using '" + this.baseDir + "'"));
        }
        if (needsJava) {
            LOG.info((Object)"Using common types.");
        }
        XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
        if (this.encoding != null) {
            this.forceDebugLog("Setting encoding.");
            this.fileEncodingSetup(this.languages.values(), this.encoding);
        }
        LOG.info((Object)"Collecting source models.");
        long startedAt = System.currentTimeMillis();
        Iterable rootsToTravers = this.classPathEntries;
        if (this.classPathLookUpFilter != null) {
            LOG.info((Object)"Class path look up filter is active.");
            Pattern cpLookUpFilter = Pattern.compile(this.classPathLookUpFilter);
            Functions.Function1 _function_1 = root -> cpLookUpFilter.matcher((CharSequence)root).matches();
            Iterable _converted_rootsToTravers = rootsToTravers = IterableExtensions.filter(this.classPathEntries, (Functions.Function1)_function_1);
            int _length = ((Object[])Conversions.unwrapArray((Object)_converted_rootsToTravers, Object.class)).length;
            String _plus = "Investigating " + Integer.valueOf(_length);
            String _plus_1 = _plus + " of ";
            int _length_1 = ((Object[])Conversions.unwrapArray(this.classPathEntries, Object.class)).length;
            String _plus_2 = _plus_1 + Integer.valueOf(_length_1);
            String _plus_3 = _plus_2 + " class path entries.";
            LOG.info((Object)_plus_3);
        }
        List<URI> sourceResourceURIs = this.collectResources(this.sourceDirs, (ResourceSet)resourceSet);
        List<URI> _collectResources = this.collectResources(rootsToTravers, (ResourceSet)resourceSet);
        Iterable allResourcesURIs = Iterables.concat(sourceResourceURIs, _collectResources);
        long _currentTimeMillis = System.currentTimeMillis();
        long _minus = _currentTimeMillis - startedAt;
        String _plus_4 = "Finished collecting source models. Took: " + Long.valueOf(_minus);
        String _plus_5 = _plus_4 + " ms.";
        this.forceDebugLog(_plus_5);
        Iterable allClassPathEntries = Iterables.concat(this.sourceDirs, this.classPathEntries);
        if (needsJava) {
            LOG.info((Object)"Installing type provider.");
            this.installTypeProvider(allClassPathEntries, resourceSet, null);
        }
        DisabledClusteringPolicy _xifexpression = null;
        if (this.clusteringConfig != null) {
            DynamicResourceClusteringPolicy _xblockexpression = null;
            LOG.info((Object)"Clustering configured.");
            DynamicResourceClusteringPolicy _dynamicResourceClusteringPolicy = new DynamicResourceClusteringPolicy();
            Procedures.Procedure1 _function_2 = it -> {
                long _minimumFreeMemory = this.clusteringConfig.getMinimumFreeMemory();
                long _multiply = _minimumFreeMemory * 1024L;
                long _multiply_1 = _multiply * 1024L;
                it.setMinimumFreeMemory(_multiply_1);
                it.setMinimumClusterSize(this.clusteringConfig.getMinimumClusterSize());
                it.setMinimumPercentFreeMemory(this.clusteringConfig.getMinimumPercentFreeMemory());
            };
            _xblockexpression = (DynamicResourceClusteringPolicy)ObjectExtensions.operator_doubleArrow((Object)_dynamicResourceClusteringPolicy, (Procedures.Procedure1)_function_2);
            _xifexpression = _xblockexpression;
        } else {
            _xifexpression = new DisabledClusteringPolicy();
        }
        DisabledClusteringPolicy strategy = _xifexpression;
        ArrayList _newArrayList = CollectionLiterals.newArrayList();
        ResourceDescriptionsData index = new ResourceDescriptionsData((Iterable)_newArrayList);
        Iterator allResourceIterator = allResourcesURIs.iterator();
        while (allResourceIterator.hasNext()) {
            ArrayList resources = CollectionLiterals.newArrayList();
            int clusterIndex = 0;
            boolean continue_ = true;
            while (allResourceIterator.hasNext() && continue_) {
                boolean _continueProcessing;
                boolean _not;
                URI uri = (URI)allResourceIterator.next();
                Resource resource = resourceSet.getResource(uri, true);
                resources.add(resource);
                this.fillIndex(uri, resource, index);
                if (!(_not = !(_continueProcessing = strategy.continueProcessing((ResourceSet)resourceSet, null, ++clusterIndex)))) continue;
                continue_ = false;
            }
            if (continue_) continue;
            this.clearResourceSet((ResourceSet)resourceSet);
        }
        this.installIndex(resourceSet, index);
        if (needsJava) {
            String stubsClasses = this.compileStubs(this.generateStubs(index, sourceResourceURIs));
            LOG.info((Object)"Installing type provider for stubs.");
            ArrayList _newArrayList_1 = CollectionLiterals.newArrayList((Object[])new String[]{stubsClasses});
            Iterable _plus_6 = Iterables.concat((Iterable)allClassPathEntries, (Iterable)_newArrayList_1);
            this.installTypeProvider(_plus_6, resourceSet, this.jvmTypeAccess);
        }
        LOG.info((Object)"Validate and generate.");
        Iterator<URI> sourceResourceIterator = sourceResourceURIs.iterator();
        boolean hasValidationErrors = false;
        while (sourceResourceIterator.hasNext()) {
            ArrayList resources = CollectionLiterals.newArrayList();
            int clusterIndex = 0;
            boolean continue_ = true;
            while (sourceResourceIterator.hasNext() && continue_) {
                boolean _continueProcessing;
                boolean _not;
                URI uri = sourceResourceIterator.next();
                Resource resource = resourceSet.getResource(uri, true);
                resources.add(resource);
                resource.getContents();
                EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
                hasValidationErrors = !this.validate(resource) || hasValidationErrors;
                if (!(_not = !(_continueProcessing = strategy.continueProcessing((ResourceSet)resourceSet, null, ++clusterIndex)))) continue;
                continue_ = false;
            }
            if (this.failOnValidationError && hasValidationErrors) {
                return !hasValidationErrors;
            }
            this.generate(resources);
            if (continue_) continue;
            this.clearResourceSet((ResourceSet)resourceSet);
        }
        return !hasValidationErrors;
    }

    public void fillIndex(URI uri, Resource resource, ResourceDescriptionsData index) {
        IResourceDescription description = this.languageAccess(uri).getResourceDescriptionManager().getResourceDescription(resource);
        index.addDescription(uri, description);
    }

    public void fileEncodingSetup(Collection<LanguageAccess> langs, String encoding) {
        for (LanguageAccess lang : langs) {
            IEncodingProvider _encodingProvider;
            IEncodingProvider provider = _encodingProvider = lang.getEncodingProvider();
            boolean _matched = false;
            if (provider instanceof IEncodingProvider.Runtime) {
                _matched = true;
                ((IEncodingProvider.Runtime)provider).setDefaultEncoding(encoding);
            }
            if (_matched) continue;
            this.forceDebugLog("Couldn't set encoding '" + encoding + "' for provider '" + provider + "'. Only subclasses of IEncodingProvider.Runtime are supported.");
        }
    }

    protected void installIndex(XtextResourceSet resourceSet, ResourceDescriptionsData index) {
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)resourceSet, (ResourceDescriptionsData)index);
    }

    protected String compileStubs(File stubsDir) {
        File stubsClasses = this.createTempDir("classes");
        this.compiler.setClassPath(this.classPathEntries);
        String _absolutePath = stubsDir.getAbsolutePath();
        String _plus = "Compiling stubs located in " + _absolutePath;
        LOG.info((Object)_plus);
        Iterable _plus_1 = Iterables.concat(this.javaSourceDirs, this.sourceDirs);
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{stubsDir.getAbsolutePath()});
        Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, (Iterable)_newArrayList);
        Set<String> sourcesToCompile = this.uniqueEntries(_plus_2);
        String _join = IterableExtensions.join(sourcesToCompile, (CharSequence)",");
        String _plus_3 = "Compiler source roots: " + _join;
        this.forceDebugLog(_plus_3);
        IJavaCompiler.CompilationResult result = this.compiler.compile(sourcesToCompile, stubsClasses);
        if (result != null) {
            switch (result) {
                case SKIPPED: {
                    LOG.info((Object)"Nothing to compile. Stubs compilation was skipped.");
                    break;
                }
                case FAILED: {
                    this.forceDebugLog("Stubs compilation finished with errors.");
                    break;
                }
                case SUCCEEDED: {
                    this.forceDebugLog("Stubs compilation successfully finished.");
                    break;
                }
            }
        }
        return stubsClasses.getAbsolutePath();
    }

    protected Set<String> uniqueEntries(Iterable<String> pathes) {
        Functions.Function1 _function = it -> new File((String)it).getAbsolutePath();
        return IterableExtensions.toSet((Iterable)IterableExtensions.map(pathes, (Functions.Function1)_function));
    }

    protected File generateStubs(ResourceDescriptionsData data, List<URI> sourceResourceURIs) {
        File stubsDir = this.createTempDir("stubs");
        String _absolutePath = stubsDir.getAbsolutePath();
        String _plus = "Generating stubs into " + _absolutePath;
        LOG.info((Object)_plus);
        if (this.encoding != null) {
            this.encodingProvider.setDefaultEncoding(this.encoding);
        }
        this.commonFileAccess.setOutputPath("DEFAULT_OUTPUT", stubsDir.getAbsolutePath());
        Functions.Function1 _function = it -> this.languageAccess((URI)it).isLinksAgainstJava();
        Iterable generateStubs = IterableExtensions.filter(sourceResourceURIs, (Functions.Function1)_function);
        Consumer<URI> _function_1 = it -> this.languageAccess((URI)it).getStubGenerator().doGenerateStubs((IFileSystemAccess)this.commonFileAccess, data.getResourceDescription(it));
        generateStubs.forEach(_function_1);
        return stubsDir;
    }

    protected boolean validate(Resource resource) {
        String _lastSegment = resource.getURI().lastSegment();
        String _plus = "Starting validation for input: '" + _lastSegment;
        String _plus_1 = _plus + "'";
        LOG.info((Object)_plus_1);
        IResourceValidator resourceValidator = this.languageAccess(resource.getURI()).getResourceValidator();
        List validationResult = resourceValidator.validate(resource, CheckMode.ALL, null);
        return this.issueHandler.handleIssue(validationResult);
    }

    protected void generate(List<Resource> sourceResources) {
        GeneratorContext context = new GeneratorContext();
        context.setCancelIndicator(CancelIndicator.NullImpl);
        for (Resource it : sourceResources) {
            String _lastSegment = it.getURI().lastSegment();
            String _plus = "Starting generator for input: '" + _lastSegment;
            String _plus_1 = _plus + "'";
            LOG.info((Object)_plus_1);
            this.registerCurrentSource(it.getURI());
            LanguageAccess access = this.languageAccess(it.getURI());
            JavaIoFileSystemAccess fileSystemAccess = this.getFileSystemAccess(access);
            boolean _isWriteStorageResources = this.isWriteStorageResources();
            if (_isWriteStorageResources) {
                boolean _matched = false;
                if (it instanceof StorageAwareResource) {
                    boolean _tripleNotEquals;
                    IResourceStorageFacade _resourceStorageFacade = ((StorageAwareResource)it).getResourceStorageFacade();
                    boolean bl = _tripleNotEquals = _resourceStorageFacade != null;
                    if (_tripleNotEquals) {
                        _matched = true;
                        ((StorageAwareResource)it).getResourceStorageFacade().saveResource((StorageAwareResource)it, (IFileSystemAccessExtension3)fileSystemAccess);
                    }
                }
            }
            access.getGenerator().generate(it, (IFileSystemAccess2)fileSystemAccess, (IGeneratorContext)context);
        }
    }

    protected void registerCurrentSource(URI uri) {
        JavaIoFileSystemAccess fsa = this.getFileSystemAccess(this.languageAccess(uri));
        Functions.Function1 _function = it -> {
            File _file = new File((String)it);
            return UriUtil.createFolderURI((File)_file);
        };
        Functions.Function1 _function_1 = it -> UriUtil.isPrefixOf((URI)it, (URI)uri);
        URI absoluteSource = (URI)IterableExtensions.findFirst((Iterable)IterableExtensions.map(this.sourceDirs, (Functions.Function1)_function), (Functions.Function1)_function_1);
        if (absoluteSource == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Resource ");
            _builder.append((Object)uri);
            _builder.append(" is not contained in any of the known source folders ");
            _builder.append(this.sourceDirs);
            _builder.append(".");
            throw new IllegalStateException(_builder.toString());
        }
        File _file = new File(this.baseDir);
        URI projectBaseURI = UriUtil.createFolderURI((File)_file);
        Collection _values = fsa.getOutputConfigurations().values();
        for (OutputConfiguration output : _values) {
            Set _sourceFolders = output.getSourceFolders();
            for (String sourceFolder : _sourceFolders) {
                boolean _equals;
                URI sourceFolderURI = URI.createURI((String)(sourceFolder + "/"));
                boolean _isRelative = sourceFolderURI.isRelative();
                if (_isRelative) {
                    sourceFolderURI = sourceFolderURI.resolve(projectBaseURI);
                }
                if (!(_equals = Objects.equal((Object)absoluteSource, (Object)sourceFolderURI))) continue;
                fsa.setCurrentSource(sourceFolder);
            }
        }
    }

    private JavaIoFileSystemAccess getFileSystemAccess(LanguageAccess language) {
        JavaIoFileSystemAccess fsa = this.configuredFsas.get(language);
        if (fsa == null) {
            File _file = new File(this.baseDir);
            fsa = language.createFileSystemAccess(_file);
            fsa = this.configureFileSystemAccess(fsa, language);
            this.configuredFsas.put(language, fsa);
        }
        return fsa;
    }

    protected JavaIoFileSystemAccess configureFileSystemAccess(JavaIoFileSystemAccess fsa, LanguageAccess language) {
        return fsa;
    }

    private LanguageAccess languageAccess(URI uri) {
        return this.languages.get(uri.fileExtension());
    }

    protected File createTempDir(String subDir) {
        try {
            File file = new File(this.tempDir, subDir);
            if (!file.mkdirs() && !file.exists()) {
                String _absolutePath = file.getAbsolutePath();
                String _plus = "Failed to create directory '" + _absolutePath;
                String _plus_1 = _plus + "'";
                throw new IOException(_plus_1);
            }
            return file;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void installTypeProvider(Iterable<String> classPathRoots, XtextResourceSet resSet, IndexedJvmTypeAccess typeAccess) {
        URLClassLoader classLoader = this.createURLClassLoader(classPathRoots);
        new ClasspathTypeProvider((ClassLoader)classLoader, (ResourceSet)resSet, typeAccess, null);
        resSet.setClasspathURIContext((Object)classLoader);
    }

    private URLClassLoader createURLClassLoader(Iterable<String> classPathEntries) {
        Functions.Function1 _function = str -> {
            try {
                return new File((String)str).toURI().toURL();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        Iterable classPathUrls = IterableExtensions.map(classPathEntries, (Functions.Function1)_function);
        return new URLClassLoader((URL[])Conversions.unwrapArray((Object)classPathUrls, URL.class));
    }

    protected List<URI> collectResources(Iterable<String> roots, ResourceSet resourceSet) {
        String extensions = IterableExtensions.join(this.languages.keySet(), (CharSequence)"|");
        NameBasedFilter nameBasedFilter = new NameBasedFilter();
        nameBasedFilter.setRegularExpression(".*\\.(?:(" + extensions + "))$");
        ArrayList resources = CollectionLiterals.newArrayList();
        Predicate _function = input -> {
            boolean matches = nameBasedFilter.matches(input);
            if (matches) {
                this.forceDebugLog("Adding file '" + input + "'");
                resources.add(input);
            }
            return matches;
        };
        Multimap modelsFound = new PathTraverser().resolvePathes(IterableExtensions.toList(roots), _function);
        BiConsumer<String, Collection> _function_1 = (uri, resource) -> {
            File file = new File((String)uri);
            if (resource != null && !file.isDirectory() && file.getName().endsWith(".jar")) {
                this.registerBundle(file);
            }
        };
        modelsFound.asMap().forEach(_function_1);
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerBundle(File file) {
        block25: {
            JarFile jarFile = null;
            try {
                JarFile _jarFile;
                jarFile = _jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    return;
                }
                String name = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (name != null) {
                    boolean _containsKey;
                    int indexOf = name.indexOf(";");
                    if (indexOf > 0) {
                        name = name.substring(0, indexOf);
                    }
                    if (_containsKey = EcorePlugin.getPlatformResourceMap().containsKey(name)) {
                        return;
                    }
                    java.net.URI _uRI = file.toURI();
                    String _plus = "archive:" + _uRI;
                    String path = _plus + "!/";
                    URI uri = URI.createURI((String)path);
                    EcorePlugin.getPlatformResourceMap().put(name, uri);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof ZipException) {
                    String _absolutePath = file.getAbsolutePath();
                    String _plus_1 = "Could not open Jar file " + _absolutePath;
                    String _plus_2 = _plus_1 + ".";
                    this.forceDebugLog(_plus_2);
                    break block25;
                }
                if (_t instanceof Exception) {
                    Exception e_1 = (Exception)_t;
                    LOG.error((Object)file.getAbsolutePath(), (Throwable)e_1);
                    break block25;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (Throwable _t_1) {
                    if (_t_1 instanceof IOException) {
                        IOException e_2 = (IOException)_t_1;
                        LOG.error((Object)jarFile, (Throwable)e_2);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t_1);
                }
            }
        }
    }

    public IJavaCompiler getCompiler() {
        return this.compiler;
    }

    public void clearResourceSet(ResourceSet resourceSet) {
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            resourceSet.getResources().clear();
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
    }

    protected void forceDebugLog(String logMessage) {
        boolean _isDebugEnabled = LOG.isDebugEnabled();
        if (_isDebugEnabled) {
            LOG.debug((Object)logMessage);
        } else if (this.debugLog) {
            LOG.info((Object)logMessage);
        }
    }

    @Pure
    public Map<String, LanguageAccess> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Map<String, LanguageAccess> languages) {
        this.languages = languages;
    }

    @Pure
    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Pure
    public Iterable<String> getSourceDirs() {
        return this.sourceDirs;
    }

    public void setSourceDirs(Iterable<String> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    @Pure
    public Iterable<String> getJavaSourceDirs() {
        return this.javaSourceDirs;
    }

    public void setJavaSourceDirs(Iterable<String> javaSourceDirs) {
        this.javaSourceDirs = javaSourceDirs;
    }

    @Pure
    public Iterable<String> getClassPathEntries() {
        return this.classPathEntries;
    }

    public void setClassPathEntries(Iterable<String> classPathEntries) {
        this.classPathEntries = classPathEntries;
    }

    @Pure
    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    @Pure
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Pure
    public String getClassPathLookUpFilter() {
        return this.classPathLookUpFilter;
    }

    public void setClassPathLookUpFilter(String classPathLookUpFilter) {
        this.classPathLookUpFilter = classPathLookUpFilter;
    }

    @Pure
    public boolean isFailOnValidationError() {
        return this.failOnValidationError;
    }

    public void setFailOnValidationError(boolean failOnValidationError) {
        this.failOnValidationError = failOnValidationError;
    }

    @Pure
    public boolean isDebugLog() {
        return this.debugLog;
    }

    public void setDebugLog(boolean debugLog) {
        this.debugLog = debugLog;
    }

    @Pure
    public boolean isWriteStorageResources() {
        return this.writeStorageResources;
    }

    public void setWriteStorageResources(boolean writeStorageResources) {
        this.writeStorageResources = writeStorageResources;
    }

    @Pure
    public ClusteringConfig getClusteringConfig() {
        return this.clusteringConfig;
    }

    public void setClusteringConfig(ClusteringConfig clusteringConfig) {
        this.clusteringConfig = clusteringConfig;
    }
}

