/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Log
public class ResourceURICollector {
    private static final Logger LOG = Logger.getLogger(ResourceURICollector.class);

    public Set<URI> collectAllResources(Iterable<URI> roots, Set<String> fileExtensions) {
        boolean _isInfoEnabled = LOG.isInfoEnabled();
        if (_isInfoEnabled) {
            LOG.info((Object)"Collecting source models.");
        }
        long startedAt = System.currentTimeMillis();
        Set<URI> result = this.collectResources(roots, fileExtensions);
        boolean _isDebugEnabled = LOG.isDebugEnabled();
        if (_isDebugEnabled) {
            long _currentTimeMillis = System.currentTimeMillis();
            long _minus = _currentTimeMillis - startedAt;
            String _plus = "Finished collecting source models. Took: " + Long.valueOf(_minus);
            String _plus_1 = _plus + " ms.";
            LOG.debug((Object)_plus_1);
        }
        return result;
    }

    protected Set<URI> collectResources(Iterable<URI> roots, Set<String> fileExtensions) {
        Iterable _plus = Iterables.concat(fileExtensions, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"java"})));
        Set extensions = IterableExtensions.toSet((Iterable)_plus);
        PathTraverser _pathTraverser = new PathTraverser();
        Functions.Function1 _function = it -> it.toFileString();
        Iterable _map = IterableExtensions.map(roots, (Functions.Function1)_function);
        List _list = IterableExtensions.toList((Iterable)_map);
        Predicate _function_1 = it -> {
            String _fileExtension = it.fileExtension();
            return extensions.contains(_fileExtension);
        };
        Multimap modelsFound = _pathTraverser.resolvePathes(_list, _function_1);
        Map _asMap = modelsFound.asMap();
        BiConsumer<String, Collection> _function_2 = (path, resource) -> {
            File file = new File((String)path);
            if (resource != null && !file.isDirectory() && file.getName().endsWith(".jar")) {
                this.registerBundle(file);
            }
        };
        _asMap.forEach(_function_2);
        Collection _values = modelsFound.values();
        return IterableExtensions.toSet((Iterable)_values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerBundle(File file) {
        block25: {
            JarFile jarFile = null;
            try {
                JarFile _jarFile;
                jarFile = _jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    return;
                }
                Attributes _mainAttributes = manifest.getMainAttributes();
                String name = _mainAttributes.getValue("Bundle-SymbolicName");
                if (name != null) {
                    Map _platformResourceMap;
                    boolean _containsKey;
                    int indexOf = name.indexOf(";");
                    if (indexOf > 0) {
                        String _substring;
                        name = _substring = name.substring(0, indexOf);
                    }
                    if (_containsKey = (_platformResourceMap = EcorePlugin.getPlatformResourceMap()).containsKey(name)) {
                        return;
                    }
                    String _absolutePath = file.getAbsolutePath();
                    URI _createFileURI = URI.createFileURI((String)_absolutePath);
                    String _plus = "archive:" + _createFileURI;
                    String path = _plus + "!/";
                    Map _platformResourceMap_1 = EcorePlugin.getPlatformResourceMap();
                    URI _createURI = URI.createURI((String)path);
                    _platformResourceMap_1.put(name, _createURI);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof ZipException) {
                    ZipException e = (ZipException)_t;
                    String _absolutePath_1 = file.getAbsolutePath();
                    String _plus_1 = "Could not open Jar file " + _absolutePath_1;
                    String _plus_2 = _plus_1 + ".";
                    LOG.info((Object)_plus_2);
                    break block25;
                }
                if (_t instanceof Exception) {
                    Exception e_1 = (Exception)_t;
                    String _absolutePath_2 = file.getAbsolutePath();
                    LOG.error((Object)_absolutePath_2, (Throwable)e_1);
                    break block25;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (Throwable _t_1) {
                    if (_t_1 instanceof IOException) {
                        IOException e_2 = (IOException)_t_1;
                        LOG.error((Object)jarFile, (Throwable)e_2);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t_1);
                }
            }
        }
    }
}

