/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.maven;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.maven.AbstractXtendMojo;
import org.eclipse.xtend.maven.ClassFileDebugSourceExtractor;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceToBytecodeInstaller;
import org.eclipse.xtext.generator.trace.TraceAsPrimarySourceInstaller;
import org.eclipse.xtext.generator.trace.TraceAsSmapInstaller;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractXtendInstallDebugInfoMojo
extends AbstractXtendMojo {
    @Inject
    protected ClassFileDebugSourceExtractor classFileDebugSourceExtractor;
    protected boolean hideSyntheticVariables;
    @Inject
    private Provider<TraceAsPrimarySourceInstaller> traceAsPrimarySourceInstallerProvider;
    @Inject
    private Provider<TraceAsSmapInstaller> traceAsSmapInstaller;
    @Inject
    private TraceFileNameProvider traceFileNameProvider;
    @Inject
    protected TraceRegionSerializer traceRegionSerializer;
    protected boolean xtendAsPrimaryDebugSource;

    protected void collectJavaSourceFile2traceFile(String root, String subdir, Map<String, File> javaSourceFile2traceFile) {
        File file = new File(String.valueOf(root) + "/" + subdir);
        File[] listFiles = file.listFiles();
        if (listFiles == null) {
            this.getLog().warn((CharSequence)("Directory " + file.getPath() + " is empty. Can't process."));
            return;
        }
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            String name = child.getName();
            if (child.isDirectory()) {
                this.collectJavaSourceFile2traceFile(root, String.valueOf(subdir) + "/" + name, javaSourceFile2traceFile);
            } else if (name.endsWith("._trace")) {
                String javaSourceFile = String.valueOf(subdir) + "/" + this.traceFileNameProvider.getJavaFromTrace(name);
                javaSourceFile2traceFile.put(javaSourceFile, child);
            }
            ++n2;
        }
    }

    protected ITraceToBytecodeInstaller createTraceToBytecodeInstaller() {
        if (this.xtendAsPrimaryDebugSource) {
            TraceAsPrimarySourceInstaller installer = (TraceAsPrimarySourceInstaller)this.traceAsPrimarySourceInstallerProvider.get();
            installer.setHideSyntheticVariables(this.hideSyntheticVariables);
            return installer;
        }
        TraceAsSmapInstaller installer = (TraceAsSmapInstaller)this.traceAsSmapInstaller.get();
        return installer;
    }

    protected Multimap<File, File> createTraceToClassFileMap(List<String> sourceFolders, String outputFolder) {
        LinkedHashMap javaSourceFile2traceFile = Maps.newLinkedHashMap();
        for (String sourceRoot : sourceFolders) {
            this.collectJavaSourceFile2traceFile(sourceRoot, "", javaSourceFile2traceFile);
        }
        LinkedHashSet packageDirs = Sets.newLinkedHashSet();
        for (String javaSourceFile : javaSourceFile2traceFile.keySet()) {
            packageDirs.add(Strings.skipLastToken((String)javaSourceFile, (String)"/"));
        }
        LinkedHashMultimap trace2class = LinkedHashMultimap.create();
        for (String packageDirName : packageDirs) {
            File packageDir = new File(String.valueOf(outputFolder) + "/" + packageDirName);
            if (!packageDir.isDirectory()) continue;
            File[] fileArray = packageDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File classFile = fileArray[n2];
                if (classFile.getName().endsWith(".class")) {
                    try {
                        File traceFile;
                        String sourceFileName = this.classFileDebugSourceExtractor.getDebugSourceFileName(classFile);
                        if (!Strings.isEmpty((String)sourceFileName) && sourceFileName.toLowerCase().endsWith(".java") && (traceFile = (File)javaSourceFile2traceFile.get(String.valueOf(packageDirName) + "/" + sourceFileName)) != null) {
                            trace2class.put((Object)traceFile, (Object)classFile);
                        }
                    }
                    catch (IOException e) {
                        this.getLog().error((CharSequence)("Error reading " + classFile), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return trace2class;
    }

    protected void installTrace(File traceFile, Collection<File> classFiles) throws FileNotFoundException, IOException {
        ITraceToBytecodeInstaller traceToBytecodeInstaller = this.createTraceToBytecodeInstaller();
        FileInputStream in = new FileInputStream(traceFile);
        try {
            AbstractTraceRegion traceRegion = this.traceRegionSerializer.readTraceRegionFrom((InputStream)in);
            traceToBytecodeInstaller.setTrace(this.traceFileNameProvider.getJavaFromTrace(traceFile.getName()), traceRegion);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Installing trace " + traceFile + " into:"));
            }
            for (File classFile : classFiles) {
                byte[] bytecodeWithTraces;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("  " + classFile));
                }
                if ((bytecodeWithTraces = traceToBytecodeInstaller.installTrace(Files.toByteArray((File)classFile))) == null) continue;
                Files.write((byte[])bytecodeWithTraces, (File)classFile);
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    protected void installTraces(Multimap<File, File> trace2class) {
        for (Map.Entry e : trace2class.asMap().entrySet()) {
            try {
                this.installTrace((File)e.getKey(), (Collection)e.getValue());
            }
            catch (Exception e1) {
                this.getLog().error((Throwable)e1);
            }
        }
    }

    protected void logStatus(String folder, Multimap<File, File> trace2class) {
        String p = this.xtendAsPrimaryDebugSource ? "primary" : "secondary (via SMAP)";
        int n = trace2class.size();
        this.getLog().info((CharSequence)("Installing Xtend files into " + n + " class files as " + p + " debug sources in: " + folder));
        this.getLog().debug((CharSequence)("xtendAsPrimaryDebugSource=" + this.xtendAsPrimaryDebugSource));
        this.getLog().debug((CharSequence)("hideSyntheticVariables=" + this.hideSyntheticVariables));
    }
}

