/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.maven;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.apache.maven.project.MavenProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.maven.MavenProjectAdapter;
import org.eclipse.xtext.generator.trace.DefaultTraceURIConverter;
import org.eclipse.xtext.generator.trace.TraceURIHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.RuntimeIOException;

public class MavenTraceURIConverter
extends DefaultTraceURIConverter {
    @Inject
    private TraceURIHelper traceURIHelper;

    public URI getURIForTrace(XtextResource context) {
        MavenProject project = MavenProjectAdapter.get(context.getResourceSet());
        URI uri = context.getResourceSet().getURIConverter().normalize(context.getURI());
        URI result = this.deresolve(project, uri);
        return result;
    }

    protected URI deresolve(MavenProject project, URI uri) {
        Iterable roots = Iterables.concat((Iterable)project.getCompileSourceRoots(), (Iterable)project.getTestCompileSourceRoots());
        for (String rootString : roots) {
            URI root = null;
            try {
                String canonicalPath = new File(rootString).getCanonicalPath();
                canonicalPath = String.valueOf(canonicalPath) + "/";
                root = URI.createFileURI((String)canonicalPath);
                if (!this.traceURIHelper.isPrefix(root, uri)) continue;
                return uri.deresolve(root);
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
        throw new RuntimeException("Could not find source folder for '" + uri + "'. Folders:" + Lists.newArrayList((Iterable)roots));
    }
}

