/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.utilities.reader;

import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockPackage;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModelPackage;
import org.eclipse.vorto.core.api.model.mapping.MappingPackage;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.editor.functionblock.FunctionblockStandaloneSetup;
import org.eclipse.vorto.editor.infomodel.InformationModelStandaloneSetup;
import org.eclipse.vorto.editor.mapping.MappingStandaloneSetup;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.utilities.reader.DefaultModelWorkspace;
import org.eclipse.vorto.utilities.reader.IModelWorkspace;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class ModelWorkspaceReader {
    private WorkspaceFileReader fileReader;
    private List<WorkspaceZipReader> zipReaders = new ArrayList<WorkspaceZipReader>();

    public ModelWorkspaceReader() {
        this.fileReader = new WorkspaceFileReader();
    }

    public ModelWorkspaceReader addFile(InputStream input, ModelType type) {
        this.fileReader.addFile(input, type);
        return this;
    }

    public ModelWorkspaceReader addZip(ZipInputStream zis) {
        this.zipReaders.add(new WorkspaceZipReader(zis));
        return this;
    }

    public IModelWorkspace read() {
        DefaultModelWorkspace workspace = new DefaultModelWorkspace();
        workspace.addModels(this.fileReader.read());
        this.zipReaders.stream().forEach(x -> workspace.addModels(x.read()));
        return workspace;
    }

    private static class WorkspaceFileReader {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private ZipOutputStream zaos = new ZipOutputStream(this.baos);
        private int counter = 0;

        public void addFile(InputStream input, ModelType type) {
            try {
                ZipEntry zipEntry = new ZipEntry(this.getNextFileName(type));
                this.zaos.putNextEntry(zipEntry);
                byte[] entrycontent = IOUtils.toByteArray((InputStream)input);
                this.zaos.write(entrycontent);
                this.zaos.closeEntry();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Could not add model", ex);
            }
        }

        private String getNextFileName(ModelType type) {
            return "model" + this.counter++ + type.getExtension();
        }

        public List<Model> read() {
            if (this.baos.size() > 0) {
                WorkspaceZipReader reader = new WorkspaceZipReader(new ZipInputStream(new ByteArrayInputStream(this.baos.toByteArray())));
                return reader.read();
            }
            return Collections.emptyList();
        }
    }

    private static class WorkspaceZipReader {
        private ZipInputStream zis;

        public WorkspaceZipReader(ZipInputStream zis) {
            this.zis = zis;
            FunctionblockPackage.eINSTANCE.eClass();
            InformationModelPackage.eINSTANCE.eClass();
            MappingPackage.eINSTANCE.eClass();
            FunctionblockStandaloneSetup.doSetup();
            InformationModelStandaloneSetup.doSetup();
        }

        public List<Model> read() {
            ZipEntry entry = null;
            Injector injector = new MappingStandaloneSetup().createInjectorAndDoEMFRegistration();
            XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
            resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
            ArrayList<Resource> infoModelResources = new ArrayList<Resource>();
            try {
                while ((entry = this.zis.getNextEntry()) != null) {
                    Resource resource = resourceSet.createResource(URI.createURI((String)("fake:/" + entry.getName())));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)this.zis, (OutputStream)baos);
                    resource.load((InputStream)new ByteArrayInputStream(baos.toByteArray()), resourceSet.getLoadOptions());
                    infoModelResources.add(resource);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Problem reading zip file", ex);
            }
            EcoreUtil2.resolveAll((ResourceSet)resourceSet);
            return infoModelResources.stream().map(r -> (Model)r.getContents().get(0)).collect(Collectors.toList());
        }
    }
}

