/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.generator.utils.javatemplates;

import java.util.Arrays;
import java.util.List;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;

public class ValueMapper {
    private static final List<String> KEYWORDS = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");

    public static String normalize(String name) {
        return KEYWORDS.contains(name) ? name + "_" : name;
    }

    public static String mapSimpleDatatype(PrimitiveType type) {
        if (type.compareTo((Enum)PrimitiveType.STRING) == 0) {
            return "String";
        }
        if (type.compareTo((Enum)PrimitiveType.DATETIME) == 0) {
            return "java.util.Date";
        }
        if (type.compareTo((Enum)PrimitiveType.BASE64_BINARY) == 0) {
            return "byte[]";
        }
        return type.getLiteral();
    }

    public static String getInitialValue(PrimitiveType type) {
        if (type.compareTo((Enum)PrimitiveType.STRING) == 0) {
            return "\"\"";
        }
        if (type.compareTo((Enum)PrimitiveType.BOOLEAN) == 0) {
            return "false";
        }
        if (type.compareTo((Enum)PrimitiveType.INT) == 0) {
            return "0";
        }
        if (type.compareTo((Enum)PrimitiveType.FLOAT) == 0) {
            return "0.0f";
        }
        if (type.compareTo((Enum)PrimitiveType.DOUBLE) == 0) {
            return "0.0d";
        }
        if (type.compareTo((Enum)PrimitiveType.DATETIME) == 0) {
            return "new java.util.Date()";
        }
        if (type.compareTo((Enum)PrimitiveType.SHORT) == 0) {
            return "0";
        }
        if (type.compareTo((Enum)PrimitiveType.BASE64_BINARY) == 0) {
            return "null";
        }
        return "";
    }
}

