/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model.runtime;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vorto.model.Infomodel;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.runtime.FunctionblockValue;
import org.eclipse.vorto.model.runtime.IValidatable;
import org.eclipse.vorto.model.runtime.ValidationReport;

public class InfomodelValue
implements IValidatable {
    private Infomodel meta = null;
    private Map<String, FunctionblockValue> functionblocks = new HashMap<String, FunctionblockValue>();

    public InfomodelValue(Infomodel meta) {
        this.meta = meta;
    }

    public void withFunctionblock(String propertyName, FunctionblockValue data) {
        this.functionblocks.put(propertyName, data);
    }

    public Map<String, FunctionblockValue> getProperties() {
        return this.functionblocks;
    }

    public FunctionblockValue get(String fbProperty) {
        return this.functionblocks.get(fbProperty);
    }

    public String toString() {
        return "InfomodelData [functionblocks=" + this.functionblocks + "]";
    }

    @Override
    public ValidationReport validate() {
        ValidationReport report = new ValidationReport();
        for (ModelProperty fbProperty : this.meta.getFunctionblocks()) {
            if (fbProperty.isMandatory() && !this.functionblocks.containsKey(fbProperty.getName())) {
                report.addItem(fbProperty, "Mandatory property is missing!");
                continue;
            }
            FunctionblockValue fbData = this.functionblocks.get(fbProperty.getName());
            if (fbData == null) continue;
            ValidationReport fbReport = fbData.validate();
            report.addReport(fbReport);
        }
        return report;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String fbProperty : this.functionblocks.keySet()) {
            result.put(fbProperty, this.functionblocks.get(fbProperty).serialize());
        }
        return result;
    }
}

