/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.targetplatform.ditto;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vorto.model.runtime.FunctionblockValue;
import org.eclipse.vorto.model.runtime.InfomodelValue;
import org.eclipse.vorto.model.runtime.PropertyValue;

public class TwinPayloadFactory {
    private static final String DEVICE_ID_SEPARATOR = ":";
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static JsonObject toDittoProtocol(InfomodelValue infomodelData, String deviceId) {
        if (!deviceId.contains(DEVICE_ID_SEPARATOR)) {
            throw new IllegalArgumentException("Device ID must comply to pattern <namespace>:<suffix>");
        }
        int separatorIndex = deviceId.indexOf(DEVICE_ID_SEPARATOR);
        return TwinPayloadFactory.toDittoProtocol(infomodelData, deviceId.substring(0, separatorIndex), deviceId.substring(separatorIndex + 1));
    }

    public static JsonObject toDittoProtocol(FunctionblockValue fbData, String featureId, String deviceId) {
        if (!deviceId.contains(DEVICE_ID_SEPARATOR)) {
            throw new IllegalArgumentException("Device ID must comply to pattern <namespace>:<suffix>");
        }
        int separatorIndex = deviceId.indexOf(DEVICE_ID_SEPARATOR);
        return TwinPayloadFactory.toDittoProtocol(fbData, featureId, deviceId.substring(0, separatorIndex), deviceId.substring(separatorIndex + 1));
    }

    public static JsonObject toDittoProtocol(InfomodelValue infomodelData, String dittoNamespace, String dittoIdSuffix) {
        HashMap<String, Object> dittoPayload = new HashMap<String, Object>();
        dittoPayload.put("topic", dittoNamespace + "/" + dittoIdSuffix + "/things/twin/commands/modify");
        dittoPayload.put("headers", TwinPayloadFactory.createHeader());
        dittoPayload.put("path", "/features");
        HashMap<String, Object> newFeatures = new HashMap<String, Object>();
        for (String infomodelProperty : infomodelData.getProperties().keySet()) {
            newFeatures.put(infomodelProperty, TwinPayloadFactory.createFeature(infomodelData.get(infomodelProperty)));
        }
        dittoPayload.put("value", newFeatures);
        return gson.toJsonTree(dittoPayload).getAsJsonObject();
    }

    private static Object createFeature(FunctionblockValue fbData) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        feature.put("definition", Arrays.asList(fbData.getMeta().getId().getPrettyFormat()));
        feature.put("properties", TwinPayloadFactory.createFunctionBlockProperties(fbData));
        return feature;
    }

    private static Object createHeader() {
        HashMap<String, Boolean> header = new HashMap<String, Boolean>();
        header.put("response-required", false);
        return header;
    }

    public static JsonObject toDittoProtocol(FunctionblockValue functionblockData, String featureId, String dittoNamespace, String dittoIdSuffix) {
        HashMap<String, Object> dittoPayload = new HashMap<String, Object>();
        dittoPayload.put("topic", dittoNamespace + "/" + dittoIdSuffix + "/things/twin/commands/modify");
        dittoPayload.put("headers", TwinPayloadFactory.createHeader());
        dittoPayload.put("path", "/features/" + featureId + "/properties");
        dittoPayload.put("value", TwinPayloadFactory.createFunctionBlockProperties(functionblockData));
        return gson.toJsonTree(dittoPayload).getAsJsonObject();
    }

    private static Map<String, Object> createFunctionBlockProperties(FunctionblockValue fbData) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> status = new HashMap<String, Object>();
        for (PropertyValue statusProperty : fbData.getStatus()) {
            status.put(statusProperty.getMeta().getName(), statusProperty.serialize());
        }
        if (!status.isEmpty()) {
            result.put("status", status);
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        for (PropertyValue configProperty : fbData.getConfiguration()) {
            config.put(configProperty.getMeta().getName(), configProperty.serialize());
        }
        if (!config.isEmpty()) {
            result.put("configuration", config);
        }
        return result;
    }
}

