/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine.serializer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.vorto.mapping.engine.model.spec.IMappingSpecification;
import org.eclipse.vorto.mapping.engine.serializer.AbstractSerializer;
import org.eclipse.vorto.model.Infomodel;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.Stereotype;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class InformationModelMappingSerializer
extends AbstractSerializer {
    public InformationModelMappingSerializer(IMappingSpecification spec, String targetPlatform) {
        super(spec, targetPlatform);
    }

    @Override
    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace ");
        Infomodel _infoModel = this.specification.getInfoModel();
        ModelId _id = _infoModel.getId();
        String _namespace = _id.getNamespace();
        _builder.append((Object)_namespace, "");
        _builder.append((Object)".mapping");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"version 1.0.0");
        _builder.newLine();
        _builder.append((Object)"displayname \"");
        Infomodel _infoModel_1 = this.specification.getInfoModel();
        ModelId _id_1 = _infoModel_1.getId();
        String _name = _id_1.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"PayloadMapping\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"description \"");
        String _lowerCase = this.targetPlatform.toLowerCase();
        String _firstUpper = StringExtensions.toFirstUpper((String)_lowerCase);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" Payload Mapping for ");
        Infomodel _infoModel_2 = this.specification.getInfoModel();
        String _displayName = _infoModel_2.getDisplayName();
        _builder.append((Object)_displayName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"category payloadmapping");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"using ");
        Infomodel _infoModel_3 = this.specification.getInfoModel();
        ModelId _id_2 = _infoModel_3.getId();
        String _namespace_1 = _id_2.getNamespace();
        _builder.append((Object)_namespace_1, "");
        _builder.append((Object)".");
        Infomodel _infoModel_4 = this.specification.getInfoModel();
        ModelId _id_3 = _infoModel_4.getId();
        String _name_1 = _id_3.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)";");
        Infomodel _infoModel_5 = this.specification.getInfoModel();
        ModelId _id_4 = _infoModel_5.getId();
        String _version = _id_4.getVersion();
        _builder.append((Object)_version, "");
        _builder.newLineIfNotEmpty();
        HashSet<String> imports = new HashSet<String>();
        _builder.newLineIfNotEmpty();
        Infomodel _infoModel_6 = this.specification.getInfoModel();
        List _functionblocks = _infoModel_6.getFunctionblocks();
        for (ModelProperty fbProperty : _functionblocks) {
            Infomodel _infoModel_7 = this.specification.getInfoModel();
            ModelId _id_5 = _infoModel_7.getId();
            String _namespace_2 = _id_5.getNamespace();
            String _plus = "using " + _namespace_2;
            String _plus_1 = _plus + ".mapping";
            String _plus_2 = (String)_plus_1 + ".";
            String _name_2 = fbProperty.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
            String _plus_3 = _plus_2 + _firstUpper_1;
            String _plus_4 = _plus_3 + "PayloadMapping";
            String _lowerCase_1 = this.targetPlatform.toLowerCase();
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)_lowerCase_1);
            String _plus_5 = _plus_4 + _firstUpper_2;
            String _plus_6 = _plus_5 + ";1.0.0";
            boolean status = imports.add(_plus_6);
            _builder.newLineIfNotEmpty();
        }
        for (String using : imports) {
            _builder.append((Object)using, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"infomodelmapping ");
        Infomodel _infoModel_8 = this.specification.getInfoModel();
        ModelId _id_6 = _infoModel_8.getId();
        String _name_3 = _id_6.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"PayloadMapping");
        String _lowerCase_2 = this.targetPlatform.toLowerCase();
        String _firstUpper_3 = StringExtensions.toFirstUpper((String)_lowerCase_2);
        _builder.append((Object)_firstUpper_3, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"targetplatform ");
        _builder.append((Object)this.targetPlatform, "\t");
        _builder.newLineIfNotEmpty();
        Infomodel _infoModel_9 = this.specification.getInfoModel();
        List _stereotypes = _infoModel_9.getStereotypes();
        List<Stereotype> _filterEmptyStereotypes = this.filterEmptyStereotypes(_stereotypes);
        for (Stereotype stereotype : _filterEmptyStereotypes) {
            _builder.append((Object)"\t");
            _builder.append((Object)"from ");
            Infomodel _infoModel_10 = this.specification.getInfoModel();
            ModelId _id_7 = _infoModel_10.getId();
            String _name_4 = _id_7.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)" to ");
            String _name_5 = stereotype.getName();
            _builder.append((Object)_name_5, "\t");
            _builder.append((Object)" with {");
            Map _attributes = stereotype.getAttributes();
            String _createContent = this.createContent(_attributes);
            _builder.append((Object)_createContent, "\t");
            _builder.append((Object)"}");
            _builder.newLineIfNotEmpty();
        }
        Infomodel _infoModel_11 = this.specification.getInfoModel();
        List _functionblocks_1 = _infoModel_11.getFunctionblocks();
        for (ModelProperty fbProperty_1 : _functionblocks_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"from ");
            Infomodel _infoModel_12 = this.specification.getInfoModel();
            ModelId _id_8 = _infoModel_12.getId();
            String _name_6 = _id_8.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)".functionblocks.");
            String _name_7 = fbProperty_1.getName();
            _builder.append((Object)_name_7, "\t");
            _builder.append((Object)" to reference ");
            String _name_8 = fbProperty_1.getName();
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_8);
            String _plus_7 = _firstUpper_4 + "PayloadMapping";
            String _lowerCase_3 = this.targetPlatform.toLowerCase();
            String _firstUpper_5 = StringExtensions.toFirstUpper((String)_lowerCase_3);
            String _plus_8 = _plus_7 + _firstUpper_5;
            _builder.append((Object)_plus_8, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private List<Stereotype> filterEmptyStereotypes(List<Stereotype> stereotypes) {
        Stream _stream = stereotypes.stream();
        Predicate<Stereotype> _function = it -> {
            Map _attributes = it.getAttributes();
            boolean _isEmpty = _attributes.isEmpty();
            return !_isEmpty;
        };
        Stream<Stereotype> _filter = _stream.filter(_function);
        Collector _list = Collectors.toList();
        return _filter.collect(_list);
    }

    private String createContent(Map<String, String> attributes) {
        StringBuilder content = new StringBuilder();
        Iterator<String> iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            StringBuilder _append = content.append(key);
            StringBuilder _append_1 = _append.append(":");
            String _get = attributes.get(key);
            String _escapeQuotes = this.escapeQuotes(_get);
            String _plus = "\"" + _escapeQuotes;
            String _plus_1 = _plus + "\"";
            _append_1.append(_plus_1);
            boolean _hasNext = iter.hasNext();
            if (!_hasNext) continue;
            content.append(",");
        }
        return content.toString();
    }

    public String escapeQuotes(String value) {
        return StringEscapeUtils.escapeJava((String)value);
    }

    @Override
    public ModelId getModelId() {
        Infomodel _infoModel = this.specification.getInfoModel();
        ModelId _id = _infoModel.getId();
        String _name = _id.getName();
        String _plus = _name + "PayloadMapping";
        String _lowerCase = this.targetPlatform.toLowerCase();
        String _firstUpper = StringExtensions.toFirstUpper((String)_lowerCase);
        String _plus_1 = _plus + _firstUpper;
        Infomodel _infoModel_1 = this.specification.getInfoModel();
        ModelId _id_1 = _infoModel_1.getId();
        String _namespace = _id_1.getNamespace();
        String _plus_2 = _namespace + ".mapping";
        return new ModelId(_plus_1, _plus_2, "1.0.0");
    }
}

