/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.internal.serializer;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.content.FunctionblockModel;
import org.eclipse.vorto.repository.api.content.Infomodel;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.repository.api.content.Stereotype;
import org.eclipse.vorto.service.mapping.internal.serializer.AbstractSerializer;
import org.eclipse.vorto.service.mapping.spec.IMappingSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FunctionblockMappingSerializer
extends AbstractSerializer {
    private String propertyName;
    private FunctionblockModel fbm;

    public FunctionblockMappingSerializer(IMappingSpecification spec, String propertyName) {
        super(spec);
        FunctionblockModel _functionBlock;
        this.propertyName = propertyName;
        this.fbm = _functionBlock = spec.getFunctionBlock(propertyName);
    }

    @Override
    public String serialize() {
        FunctionblockModel _functionBlock_1;
        Optional _stereotype_1;
        Stereotype _get;
        Map _attributes;
        boolean _isEmpty;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace ");
        Infomodel _infoModel = this.specification.getInfoModel();
        ModelId _id = _infoModel.getId();
        String _namespace = _id.getNamespace();
        _builder.append((Object)_namespace, "");
        _builder.append((Object)".mapping");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"version 1.0.0");
        _builder.newLine();
        _builder.append((Object)"displayname \"");
        _builder.append((Object)this.propertyName, "");
        _builder.append((Object)"PayloadMapping\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"description \"Payload Mapping for the ");
        _builder.append((Object)this.propertyName, "");
        _builder.append((Object)" property of the ");
        Infomodel _infoModel_1 = this.specification.getInfoModel();
        String _displayName = _infoModel_1.getDisplayName();
        _builder.append((Object)_displayName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"category payloadmapping");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"using ");
        ModelId _id_1 = this.fbm.getId();
        String _prettyFormat = _id_1.getPrettyFormat();
        String _replace = _prettyFormat.replace(":", ";");
        _builder.append((Object)_replace, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"functionblockmapping ");
        String _firstUpper = StringExtensions.toFirstUpper((String)this.propertyName);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"PayloadMapping {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"targetplatform ");
        String _createTargetPlatformKey = this.createTargetPlatformKey();
        _builder.append((Object)_createTargetPlatformKey, "\t");
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        FunctionblockModel _functionBlock = this.specification.getFunctionBlock(this.propertyName);
        Optional _stereotype = _functionBlock.getStereotype("functions");
        boolean _isPresent = _stereotype.isPresent();
        _and = !_isPresent ? false : (_not = !(_isEmpty = (_attributes = (_get = (Stereotype)(_stereotype_1 = (_functionBlock_1 = this.specification.getFunctionBlock(this.propertyName)).getStereotype("functions")).get()).getAttributes()).isEmpty()));
        if (_and) {
            _builder.append((Object)"\t");
            _builder.append((Object)"from ");
            ModelId _id_2 = this.fbm.getId();
            String _name = _id_2.getName();
            _builder.append((Object)_name, "\t");
            _builder.append((Object)" to functions with {");
            FunctionblockModel _functionBlock_2 = this.specification.getFunctionBlock(this.propertyName);
            Optional _stereotype_2 = _functionBlock_2.getStereotype("functions");
            Stereotype _get_1 = (Stereotype)_stereotype_2.get();
            String _createFunctions = this.createFunctions(_get_1);
            _builder.append((Object)_createFunctions, "\t");
            _builder.append((Object)"}");
            _builder.newLineIfNotEmpty();
        }
        List _statusProperties = this.fbm.getStatusProperties();
        for (ModelProperty statusProperty : _statusProperties) {
            List _stereotypes = statusProperty.getStereotypes();
            List<Stereotype> _filterEmptyStereotypes = this.filterEmptyStereotypes(_stereotypes);
            for (Stereotype stereotype : _filterEmptyStereotypes) {
                _builder.append((Object)"\t");
                _builder.append((Object)"from ");
                ModelId _id_3 = this.fbm.getId();
                String _name_1 = _id_3.getName();
                _builder.append((Object)_name_1, "\t");
                _builder.append((Object)".status.");
                String _name_2 = statusProperty.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append((Object)" to ");
                String _name_3 = stereotype.getName();
                _builder.append((Object)_name_3, "\t");
                _builder.append((Object)" with {");
                Map _attributes_1 = stereotype.getAttributes();
                String _createContent = this.createContent(_attributes_1);
                _builder.append((Object)_createContent, "\t");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
        }
        List _configurationProperties = this.fbm.getConfigurationProperties();
        for (ModelProperty configProperty : _configurationProperties) {
            List _stereotypes_1 = configProperty.getStereotypes();
            List<Stereotype> _filterEmptyStereotypes_1 = this.filterEmptyStereotypes(_stereotypes_1);
            for (Stereotype stereotype_1 : _filterEmptyStereotypes_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"from ");
                ModelId _id_4 = this.fbm.getId();
                String _name_4 = _id_4.getName();
                _builder.append((Object)_name_4, "\t");
                _builder.append((Object)".configuration.");
                String _name_5 = configProperty.getName();
                _builder.append((Object)_name_5, "\t");
                _builder.append((Object)" to ");
                String _name_6 = stereotype_1.getName();
                _builder.append((Object)_name_6, "\t");
                _builder.append((Object)" with {");
                Map _attributes_2 = stereotype_1.getAttributes();
                String _createContent_1 = this.createContent(_attributes_2);
                _builder.append((Object)_createContent_1, "\t");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String createFunctions(Stereotype functionsStereotype) {
        StringBuilder content = new StringBuilder();
        Iterator iter = functionsStereotype.getAttributes().keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            boolean _equals = "_namespace".equals(key);
            boolean _not = !_equals;
            if (!_not) continue;
            StringBuilder _append = content.append(key);
            StringBuilder _append_1 = _append.append(":");
            Map _attributes = functionsStereotype.getAttributes();
            String _get = (String)_attributes.get(key);
            String _escapeQuotes = this.escapeQuotes(_get);
            String _plus = "\"" + _escapeQuotes;
            String _plus_1 = _plus + "\"";
            _append_1.append(_plus_1);
            boolean _hasNext = iter.hasNext();
            if (!_hasNext) continue;
            content.append(",");
        }
        return content.toString();
    }

    public String escapeQuotes(String value) {
        return StringEscapeUtils.escapeJava((String)value);
    }

    private List<Stereotype> filterEmptyStereotypes(List<Stereotype> stereotypes) {
        Stream _stream = stereotypes.stream();
        Predicate<Stereotype> _function = it -> {
            Map _attributes_1;
            String _get;
            boolean _equals;
            boolean _not;
            boolean _and = false;
            Map _attributes = it.getAttributes();
            boolean _containsKey = _attributes.containsKey("xpath");
            _and = !_containsKey ? false : (_not = !(_equals = (_get = (String)(_attributes_1 = it.getAttributes()).get("xpath")).equals("")));
            return _and;
        };
        Stream<Stereotype> _filter = _stream.filter(_function);
        Collector _list = Collectors.toList();
        return _filter.collect(_list);
    }

    private String createContent(Map<String, String> attributes) {
        StringBuilder content = new StringBuilder();
        Iterator<String> iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            StringBuilder _append = content.append(key);
            StringBuilder _append_1 = _append.append(":");
            String _get = attributes.get(key);
            String _escapeQuotes = this.escapeQuotes(_get);
            String _plus = "\"" + _escapeQuotes;
            String _plus_1 = _plus + "\"";
            _append_1.append(_plus_1);
            boolean _hasNext = iter.hasNext();
            if (!_hasNext) continue;
            content.append(",");
        }
        return content.toString();
    }
}

