/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.internal.ditto;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vorto.service.mapping.ditto.Feature;
import org.eclipse.vorto.service.mapping.internal.ditto.EmptyFeature;
import org.eclipse.vorto.service.mapping.internal.ditto.FeatureImpl;

public class FeatureBuilder {
    private FeatureImpl feature;

    public FeatureBuilder(String name) {
        this.feature = new FeatureImpl(name);
    }

    public FeatureBuilder withProperty(String name, Object value) {
        this.feature.getProperties().put(name, value);
        return this;
    }

    public FeatureBuilder withStatusProperty(String name, Object value) {
        HashMap<String, Object> statusProperties = new HashMap<String, Object>(this.feature.getStatusProperties());
        statusProperties.put(name, value);
        this.feature.getProperties().put("status", statusProperties);
        return this;
    }

    public FeatureBuilder withStatus(Map<String, Object> statusProperties) {
        this.feature.getProperties().put("status", statusProperties);
        return this;
    }

    public FeatureBuilder withConfigurationProperty(String name, Object value) {
        HashMap<String, Object> statusProperties = new HashMap<String, Object>(this.feature.getConfigurationProperties());
        statusProperties.put(name, value);
        this.feature.getProperties().put("configuration", statusProperties);
        return this;
    }

    public FeatureBuilder withConfiguration(Map<String, Object> configurationProperties) {
        this.feature.getProperties().put("configuration", configurationProperties);
        return this;
    }

    public Feature build() {
        return this.feature.getProperties().size() == 0 ? new EmptyFeature(this.feature.getId()) : this.feature;
    }
}

