/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.spec;

import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.eclipse.vorto.repository.api.IModelRepository;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.content.FunctionblockModel;
import org.eclipse.vorto.repository.api.content.Infomodel;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.repository.api.content.Stereotype;
import org.eclipse.vorto.repository.client.RepositoryClientBuilder;
import org.eclipse.vorto.service.mapping.internal.converter.JavascriptFunctions;
import org.eclipse.vorto.service.mapping.internal.spec.DefaultMappingSpecification;
import org.eclipse.vorto.service.mapping.spec.IMappingSpecification;
import org.eclipse.vorto.service.mapping.spec.MappingSpecificationProblem;

public class MappingSpecificationBuilder {
    private IModelRepository repositoryClient = null;
    private String modelId;
    private String targetPlatformKey;
    private FunctionLibrary library = new FunctionLibrary();
    private static final String STEREOTYPE_FUNCTIONS = "functions";

    private MappingSpecificationBuilder(IModelRepository repository) {
        this.repositoryClient = repository;
    }

    public static MappingSpecificationBuilder create() {
        return new MappingSpecificationBuilder(RepositoryClientBuilder.newBuilder().setBaseUrl("http://vorto.eclipse.org").buildModelRepositoryClient());
    }

    public MappingSpecificationBuilder remoteClient(IModelRepository repositoryClient) {
        this.repositoryClient = repositoryClient;
        return this;
    }

    public MappingSpecificationBuilder infomodelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    public MappingSpecificationBuilder targetPlatformKey(String key) {
        this.targetPlatformKey = key;
        return this;
    }

    public IMappingSpecification build() {
        try {
            Infomodel infomodel = (Infomodel)this.repositoryClient.getContent(ModelId.fromPrettyFormat((String)this.modelId), Infomodel.class, this.targetPlatformKey).get();
            if (infomodel == null) {
                throw new MappingSpecificationProblem("Didn't find any information model [" + this.modelId + "] for platform [" + this.targetPlatformKey + "]");
            }
            DefaultMappingSpecification specification = new DefaultMappingSpecification();
            specification.setInfomodel(infomodel);
            for (ModelProperty fbProperty : infomodel.getFunctionblocks()) {
                ModelId fbModelId = (ModelId)fbProperty.getType();
                ModelId mappingId = fbProperty.getMappingReference();
                FunctionblockModel fbm = mappingId != null ? (FunctionblockModel)this.repositoryClient.getContent(fbModelId, FunctionblockModel.class, mappingId).get() : (FunctionblockModel)this.repositoryClient.getContent(fbModelId, FunctionblockModel.class, this.targetPlatformKey).get();
                if (fbm.getStereotype(STEREOTYPE_FUNCTIONS).isPresent()) {
                    Stereotype functionsStereotype = (Stereotype)fbm.getStereotype(STEREOTYPE_FUNCTIONS).get();
                    JavascriptFunctions functions = new JavascriptFunctions(fbProperty.getName().toLowerCase());
                    for (String functionName : functionsStereotype.getAttributes().keySet()) {
                        if ("_namespace".equalsIgnoreCase(functionName)) continue;
                        functions.addFunction(functionName, (String)functionsStereotype.getAttributes().get(functionName));
                    }
                    this.library.addFunctions((Functions)functions);
                }
                specification.getFbs().put(fbProperty.getName(), fbm);
            }
            specification.setLibrary(this.library);
            return specification;
        }
        catch (Exception e) {
            throw new MappingSpecificationProblem("Problem reading mapping specification", e);
        }
    }
}

