/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.normalized;

import java.util.HashMap;
import java.util.Map;

public class Command {
    private String cmdName;
    private String fbPropertyName;
    private Map<String, Object> params = new HashMap<String, Object>();

    public static CommandBuilder forFunctionBlockProperty(String fbProperty) {
        return new CommandBuilder(fbProperty);
    }

    public void putParam(String name, Object value) {
        this.params.put(name, value);
    }

    public String getCmdName() {
        return this.cmdName;
    }

    public void setCmdName(String cmdName) {
        this.cmdName = cmdName;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getFbPropertyName() {
        return this.fbPropertyName;
    }

    public void setFbPropertyName(String fbPropertyName) {
        this.fbPropertyName = fbPropertyName;
    }

    public String toString() {
        return "Command [cmdName=" + this.cmdName + ", fbPropertyName=" + this.fbPropertyName + ", params=" + this.params + "]";
    }

    public static class CommandBuilder {
        private Command cmd = new Command();

        public CommandBuilder(String fbProperty) {
            this.cmd.setFbPropertyName(fbProperty);
        }

        public CommandBuilder name(String name) {
            this.cmd.setCmdName(name);
            return this;
        }

        public CommandBuilder param(String name, Object value) {
            this.cmd.getParams().put(name, value);
            return this;
        }

        public Command build() {
            return this.cmd;
        }
    }
}

