/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.internal;

import java.util.Optional;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.jxpath.BasicNodeSet;
import org.apache.commons.jxpath.ClassFunctions;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.util.BasicTypeConverter;
import org.apache.commons.jxpath.util.TypeConverter;
import org.apache.commons.jxpath.util.TypeUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Conversion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.vorto.service.mapping.internal.converter.Arrays;
import org.eclipse.vorto.service.mapping.internal.converter.Base64;
import org.eclipse.vorto.service.mapping.internal.converter.ConvertUtils;
import org.eclipse.vorto.service.mapping.internal.converter.DateUtils;
import org.eclipse.vorto.service.mapping.internal.converter.String2Utils;

public class JxPathFactory {
    private FunctionLibrary converterLibrary = new FunctionLibrary();
    private boolean lenient = false;

    public JxPathFactory(Optional<Functions> functionsFromMappings) {
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(Conversion.class, "conversion"));
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(StringUtils.class, "string"));
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(String2Utils.class, "string2"));
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(NumberUtils.class, "number"));
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(DateUtils.class, "date"));
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(ConvertUtils.class, "type"));
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(BooleanUtils.class, "boolean"));
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(Base64.class, "base64"));
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(DatatypeConverter.class, "binaryString"));
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(EndianUtils.class, "endian"));
        this.converterLibrary.addFunctions((Functions)new ClassFunctions(Arrays.class, "array"));
        if (functionsFromMappings.isPresent()) {
            this.converterLibrary.addFunctions(functionsFromMappings.get());
        }
    }

    public JxPathFactory() {
        this(Optional.empty());
    }

    public JXPathContext newContext(Object ctxObject) {
        JXPathContext context = JXPathContext.newContext((Object)ctxObject);
        TypeUtils.setTypeConverter((TypeConverter)new MyTypeConverter());
        context.setFunctions((Functions)this.converterLibrary);
        context.setLenient(this.lenient);
        return context;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public static class MyTypeConverter
    extends BasicTypeConverter {
        public Object convert(Object object, Class toType) {
            if (object instanceof BasicNodeSet && ((BasicNodeSet)object).getValues().isEmpty()) {
                throw new JXPathNotFoundException("Could not find path in source");
            }
            return super.convert(object, toType);
        }
    }
}

