/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping.ble;

import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.vorto.service.mapping.ble.BleGattCharacteristic;

public class BleGattInitSequenceElement {
    private BleGattCharacteristic characteristic;
    private Short[] value;

    public BleGattInitSequenceElement(BleGattCharacteristic characteristic, String value) {
        this.characteristic = characteristic;
        this.setValue(value);
    }

    public void setValue(String value) {
        String[] digits = value.split(" ");
        if (digits != null) {
            Stream<Short> bytes = Arrays.stream(digits).map(s -> Short.parseShort(s, 16));
            this.value = (Short[])bytes.toArray(Short[]::new);
        }
    }

    public String getValue() {
        String result = "";
        for (Short v : this.value) {
            String digit = String.format("%02x", v);
            result = result + digit;
        }
        return result;
    }

    public BleGattCharacteristic getCharacteristic() {
        return this.characteristic;
    }
}

